/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen.nether;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.worldgen.NoiseGenerator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenNetherClay
extends WorldgenObject {
    @SafeVarargs
    public WorldgenNetherClay(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        NoiseGenerator tNoise = new NoiseGenerator(aWorld);
        int tUpperBound = WD.waterLevel(aWorld) + 3;
        int tLowerBound = WD.waterLevel(aWorld) + 2;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (tNoise.get(aMinX + i, 42.0f, aMinZ + j, 8) != 0) continue;
                for (int tY = tUpperBound; tY >= tLowerBound; --tY) {
                    if (aChunk.func_150810_a(i, tY, j) != Blocks.field_150424_aL) continue;
                    WD.set(aChunk, i, tY, j, CS.BlocksGT.Diggables, 3L);
                }
            }
        }
        return true;
    }
}

