/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.base.TileEntityBase11AttachmentSmall;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class MultiTileEntityFluidCapNozzle
extends TileEntityBase11AttachmentSmall {
    public boolean mAcidProof = false;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/capnozzle/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/capnozzle/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tools/capnozzle/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/capnozzle/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/capnozzle/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tools/capnozzle/overlay/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.tank"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        FluidStack tFluid;
        ItemStack aStack;
        if (this.isServerSide() && (aStack = aPlayer.func_71045_bC()) != null && FL.gas(tFluid = FL.getFluid(ST.amount(1L, aStack), true), false) && tFluid.amount > 0 && (this.mAcidProof || !FL.acid(tFluid))) {
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(this.mFacing);
            if (tDelegator.mTileEntity instanceof ITileEntityFunnelAccessible) {
                int tAmount = ((ITileEntityFunnelAccessible)tDelegator.mTileEntity).capnozzleFill(tDelegator.mSideOfTileEntity, tFluid, false);
                if (tAmount >= tFluid.amount && ((ITileEntityFunnelAccessible)tDelegator.mTileEntity).capnozzleFill(tDelegator.mSideOfTileEntity, tFluid, true) > 0) {
                    UT.Sounds.send("random.fizz", 1.0f, 2.0f, this, false);
                    --aStack.field_77994_a;
                    ST.give((Entity)aPlayer, ST.container(ST.amount(1L, aStack), true), true);
                    return true;
                }
                if (aStack.func_77973_b() instanceof IFluidContainerItem && aStack.field_77994_a == 1) {
                    UT.Sounds.send("random.fizz", 1.0f, 2.0f, this, false);
                    ((IFluidContainerItem)aStack.func_77973_b()).drain(aStack, ((ITileEntityFunnelAccessible)tDelegator.mTileEntity).capnozzleFill(tDelegator.mSideOfTileEntity, tFluid, true), true);
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 2;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[1], CS.PX_N[6], CS.PX_N[9], CS.PX_N[10]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[10], CS.PX_N[6], CS.PX_N[9], CS.PX_N[1]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[1], CS.PX_P[3], CS.PX_P[6], CS.PX_N[10], CS.PX_N[9], CS.PX_N[6]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[10], CS.PX_P[3], CS.PX_P[6], CS.PX_N[1], CS.PX_N[9], CS.PX_N[6]);
                return true;
            }
            case 1: {
                switch (this.mFacing) {
                    case 2: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[4], CS.PX_P[0], CS.PX_N[7], CS.PX_N[10], CS.PX_N[14]);
                        return true;
                    }
                    default: {
                        this.box(aBlock, CS.PX_P[7], CS.PX_P[4], CS.PX_P[14], CS.PX_N[7], CS.PX_N[10], CS.PX_N[0]);
                        return true;
                    }
                    case 4: {
                        this.box(aBlock, CS.PX_P[0], CS.PX_P[4], CS.PX_P[7], CS.PX_N[14], CS.PX_N[10], CS.PX_N[7]);
                        return true;
                    }
                    case 5: 
                }
                this.box(aBlock, CS.PX_P[14], CS.PX_P[4], CS.PX_P[7], CS.PX_N[0], CS.PX_N[10], CS.PX_N[7]);
                return true;
            }
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 1 && aSide == this.mFacing && !aShouldSideBeRendered[aSide] ? null : BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]]));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        switch (this.mFacing) {
            case 2: {
                return this.box(CS.PX_P[6], CS.PX_P[3], CS.PX_P[0], CS.PX_N[6], CS.PX_N[9], CS.PX_N[10]);
            }
            default: {
                return this.box(CS.PX_P[6], CS.PX_P[3], CS.PX_P[10], CS.PX_N[6], CS.PX_N[9], CS.PX_N[0]);
            }
            case 4: {
                return this.box(CS.PX_P[0], CS.PX_P[3], CS.PX_P[6], CS.PX_N[10], CS.PX_N[9], CS.PX_N[6]);
            }
            case 5: 
        }
        return this.box(CS.PX_P[10], CS.PX_P[3], CS.PX_P[6], CS.PX_N[0], CS.PX_N[9], CS.PX_N[6]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        switch (this.mFacing) {
            case 2: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[0], CS.PX_N[6], CS.PX_N[9], CS.PX_N[10]);
                break;
            }
            default: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[3], CS.PX_P[10], CS.PX_N[6], CS.PX_N[9], CS.PX_N[0]);
                break;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[3], CS.PX_P[6], CS.PX_N[10], CS.PX_N[9], CS.PX_N[6]);
                break;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[10], CS.PX_P[3], CS.PX_P[6], CS.PX_N[0], CS.PX_N[9], CS.PX_N[6]);
            }
        }
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.capnozzle";
    }
}

