/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityRemoteActivateable;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.StoneLayer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class MultiTileEntityDynamite
extends TileEntityBase09FacingSingle
implements ITileEntityRemoteActivateable,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool {
    public byte mCountDown = 0;
    public byte mFortune = 0;
    public boolean mSunk = false;
    public long mMaxExplosionResistance = 10L;
    private boolean mDontDrop = false;
    public static final IIconContainer sTextureFront = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/colored/front");
    public static final IIconContainer sTextureBack = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/colored/back");
    public static final IIconContainer sTextureSide = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/colored/side");
    public static final IIconContainer sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/overlay/front");
    public static final IIconContainer sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/overlay/back");
    public static final IIconContainer sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/overlay/side");
    public static final IIconContainer sTextureFrontActive = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/colored_active/front");
    public static final IIconContainer sTextureBackActive = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/colored_active/back");
    public static final IIconContainer sTextureSideActive = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/colored_active/side");
    public static final IIconContainer sOverlayFrontActive = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/overlay_active/front");
    public static final IIconContainer sOverlayBackActive = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/overlay_active/back");
    public static final IIconContainer sOverlaySideActive = new Textures.BlockIcons.CustomIcon("machines/tools/dynamite/overlay_active/side");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state")) {
            this.mCountDown = aNBT.func_74771_c("gt.state");
        }
        if (aNBT.func_74764_b("gt.mode")) {
            this.mSunk = aNBT.func_74767_n("gt.mode");
        }
        if (aNBT.func_74764_b("gt.quality")) {
            this.mMaxExplosionResistance = aNBT.func_74763_f("gt.quality");
        }
        if (aNBT.func_74764_b("gt.fortune")) {
            this.mFortune = aNBT.func_74771_c("gt.fortune");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        aNBT.func_74774_a("gt.state", this.mCountDown);
        UT.NBT.setBoolean(aNBT, "gt.mode", this.mSunk);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.blastpower") + LH.Chat.WHITE + this.mMaxExplosionResistance);
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.blastrange") + LH.Chat.WHITE + "3x3x3");
        if (this.mFortune > 0) {
            aList.add(LH.Chat.PINK + LH.get("gt.lang.blastfortune") + LH.Chat.WHITE + this.mFortune);
        }
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.requirement.ignite.fire"));
        aList.add(LH.Chat.RED + LH.get("gt.lang.explosive"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("igniter") && this.mCountDown == 0 && WD.oxygen(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.mCountDown = (byte)100;
            this.updateClientData();
            this.causeBlockUpdate();
            UT.Sounds.send("game.tnt.primed", 1.0f, 0.5f, this, false);
            return 10000L;
        }
        if (aTool.equals("extinguisher") && this.mCountDown != 0) {
            this.mCountDown = 0;
            this.updateClientData();
            this.causeBlockUpdate();
            UT.Sounds.send("random.fizz", 1.0f, 0.5f, this, false);
            return 10000L;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mBlockUpdated || aTimer == 2L) {
                Block tBlock;
                if (this.mCountDown == 0 && this.hasRedstoneIncoming() || WD.burning(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    this.remoteActivate();
                }
                if (!(!this.mSunk || CS.BlocksGT.drillableDynamite.contains(tBlock = this.getBlockAtSide(CS.OPOS[this.mFacing])) || tBlock.func_149712_f(this.field_145850_b, this.field_145851_c + CS.OFFX[CS.OPOS[this.mFacing]], this.field_145848_d + CS.OFFY[CS.OPOS[this.mFacing]], this.field_145849_e + CS.OFFZ[CS.OPOS[this.mFacing]]) >= 0.0f && (tBlock instanceof BlockStones ? this.getMetaDataAtSide(CS.OPOS[this.mFacing]) < 3 : StoneLayer.REPLACEABLE_BLOCKS.contains(tBlock) || WD.ore_stone(tBlock, this.getMetaDataAtSide(CS.OPOS[this.mFacing]))))) {
                    this.mSunk = false;
                    this.updateClientData();
                    this.causeBlockUpdate();
                }
            }
            if (this.mCountDown > 0 && (this.mCountDown = (byte)(this.mCountDown - 1)) <= 0) {
                this.explode(false);
            }
        }
    }

    @Override
    public void setVisualData(byte aData) {
        this.mCountDown = (byte)(aData >>> 1);
        this.mSunk = (aData & 1) != 0;
    }

    @Override
    public byte getVisualData() {
        return (byte)(this.mCountDown << 1 | (this.mSunk ? 1 : 0));
    }

    @Override
    public void explode(boolean aInstant) {
        this.mDontDrop = true;
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        DynamiteExplosion tExplosion = this.mSunk ? new DynamiteExplosion(this.field_145850_b, (double)this.getOffsetXN(this.mFacing) + 0.5, (double)this.getOffsetYN(this.mFacing) + 0.5, (double)this.getOffsetZN(this.mFacing) + 0.5, this.mMaxExplosionResistance, this.mFortune) : new DynamiteExplosion(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, this.mMaxExplosionResistance, this.mFortune);
        tExplosion.func_77278_a();
        tExplosion.func_77279_a(true);
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return this.mDontDrop ? new ArrayListNoNulls() : super.getDrops(aFortune, aSilkTouch);
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        this.box(aBlock, CS.PX_P[4 == this.mFacing ? (this.mSunk ? 14 : 0) : (5 == this.mFacing ? 0 : 5)], CS.PX_P[0 == this.mFacing ? (this.mSunk ? 14 : 0) : (1 == this.mFacing ? 0 : 5)], CS.PX_P[2 == this.mFacing ? (this.mSunk ? 14 : 0) : (3 == this.mFacing ? 0 : 5)], CS.PX_N[5 == this.mFacing ? (this.mSunk ? 14 : 0) : (4 == this.mFacing ? 0 : 5)], CS.PX_N[1 == this.mFacing ? (this.mSunk ? 14 : 0) : (0 == this.mFacing ? 0 : 5)], CS.PX_N[3 == this.mFacing ? (this.mSunk ? 14 : 0) : (2 == this.mFacing ? 0 : 5)]);
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aSide == this.mFacing) {
            return BlockTextureMulti.get(BlockTextureDefault.get(this.mCountDown != 0 ? sTextureFrontActive : sTextureFront, this.mRGBa, false, false, false, false), BlockTextureDefault.get(this.mCountDown != 0 ? sOverlayFrontActive : sOverlayFront));
        }
        if (aSide == CS.OPOS[this.mFacing]) {
            return BlockTextureMulti.get(BlockTextureDefault.get(this.mCountDown != 0 ? sTextureBackActive : sTextureBack, this.mRGBa, false, false, false, false), BlockTextureDefault.get(this.mCountDown != 0 ? sOverlayBackActive : sOverlayBack));
        }
        return BlockTextureMulti.get(BlockTextureDefault.get(this.mCountDown != 0 ? sTextureSideActive : sTextureSide, this.mRGBa, false, false, false, false), BlockTextureDefault.get(this.mCountDown != 0 ? sOverlaySideActive : sOverlaySide));
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[4 == this.mFacing ? (this.mSunk ? 14 : 0) : (5 == this.mFacing ? 0 : 5)], CS.PX_P[0 == this.mFacing ? (this.mSunk ? 14 : 0) : (1 == this.mFacing ? 0 : 5)], CS.PX_P[2 == this.mFacing ? (this.mSunk ? 14 : 0) : (3 == this.mFacing ? 0 : 5)], CS.PX_N[5 == this.mFacing ? (this.mSunk ? 14 : 0) : (4 == this.mFacing ? 0 : 5)], CS.PX_N[1 == this.mFacing ? (this.mSunk ? 14 : 0) : (0 == this.mFacing ? 0 : 5)], CS.PX_N[3 == this.mFacing ? (this.mSunk ? 14 : 0) : (2 == this.mFacing ? 0 : 5)]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[4 == this.mFacing ? (this.mSunk ? 14 : 0) : (5 == this.mFacing ? 0 : 5)], CS.PX_P[0 == this.mFacing ? (this.mSunk ? 14 : 0) : (1 == this.mFacing ? 0 : 5)], CS.PX_P[2 == this.mFacing ? (this.mSunk ? 14 : 0) : (3 == this.mFacing ? 0 : 5)], CS.PX_N[5 == this.mFacing ? (this.mSunk ? 14 : 0) : (4 == this.mFacing ? 0 : 5)], CS.PX_N[1 == this.mFacing ? (this.mSunk ? 14 : 0) : (0 == this.mFacing ? 0 : 5)], CS.PX_N[3 == this.mFacing ? (this.mSunk ? 14 : 0) : (2 == this.mFacing ? 0 : 5)]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[4 == this.mFacing ? (this.mSunk ? 14 : 0) : (5 == this.mFacing ? 0 : 5)], CS.PX_P[0 == this.mFacing ? (this.mSunk ? 14 : 0) : (1 == this.mFacing ? 0 : 5)], CS.PX_P[2 == this.mFacing ? (this.mSunk ? 14 : 0) : (3 == this.mFacing ? 0 : 5)], CS.PX_N[5 == this.mFacing ? (this.mSunk ? 14 : 0) : (4 == this.mFacing ? 0 : 5)], CS.PX_N[1 == this.mFacing ? (this.mSunk ? 14 : 0) : (0 == this.mFacing ? 0 : 5)], CS.PX_N[3 == this.mFacing ? (this.mSunk ? 14 : 0) : (2 == this.mFacing ? 0 : 5)]);
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return (byte)(this.mCountDown != 0 ? 15 : 0);
    }

    @Override
    public byte isProvidingStrongPower2(byte aSide) {
        return (byte)(this.mCountDown != 0 ? 15 : 0);
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        this.mDontDrop = true;
        super.onExploded(aExplosion);
        this.explode(true);
    }

    @Override
    public boolean remoteActivate() {
        if (this.mCountDown > 20 || this.mCountDown == 0) {
            this.mCountDown = (byte)20;
            this.updateClientData();
            this.causeBlockUpdate();
        }
        return false;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean useSidePlacementRotation() {
        return true;
    }

    @Override
    public boolean useInversePlacementRotation() {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.dynamite";
    }

    public static class DynamiteExplosion
    extends Explosion {
        public World mWorld;
        public float mMaxExplosionResistance;
        public byte mFortune;

        public DynamiteExplosion(World aWorld, double aX, double aY, double aZ, float aMaxExplosionResistance, byte aFortune) {
            super(aWorld, null, aX, aY, aZ, 1.0f);
            this.mMaxExplosionResistance = aMaxExplosionResistance;
            this.mFortune = aFortune;
            this.mWorld = aWorld;
        }

        public void func_77278_a() {
            for (int tX = UT.Code.roundDown(this.field_77284_b) - 1; tX <= UT.Code.roundDown(this.field_77284_b) + 1; ++tX) {
                for (int tY = UT.Code.roundDown(this.field_77285_c) - 1; tY <= UT.Code.roundDown(this.field_77285_c) + 1; ++tY) {
                    for (int tZ = UT.Code.roundDown(this.field_77282_d) - 1; tZ <= UT.Code.roundDown(this.field_77282_d) + 1; ++tZ) {
                        Block tBlock = this.mWorld.func_147439_a(tX, tY, tZ);
                        if (tBlock == Blocks.field_150474_ac || WD.bedrock(tBlock) || !(tBlock.getExplosionResistance(this.field_77283_e, this.mWorld, tX, tY, tZ, this.field_77284_b, this.field_77285_c, this.field_77282_d) <= this.mMaxExplosionResistance)) continue;
                        this.field_77281_g.add(new ChunkPosition(tX, tY, tZ));
                    }
                }
            }
            List tList = this.mWorld.func_72839_b(this.field_77283_e, AxisAlignedBB.func_72330_a((double)(this.field_77284_b - 2.0), (double)(this.field_77285_c - 2.0), (double)(this.field_77282_d - 2.0), (double)(this.field_77284_b + 2.0), (double)(this.field_77285_c + 2.0), (double)(this.field_77282_d + 2.0)));
            ForgeEventFactory.onExplosionDetonate((World)this.mWorld, (Explosion)this, (List)tList, (double)this.field_77280_f);
            DamageSource tSource = DamageSource.func_94539_a((Explosion)this);
            for (Object tEntity : tList) {
                if (tEntity instanceof EntityItem) continue;
                ((Entity)tEntity).func_70097_a(tSource, 2.0f * this.mMaxExplosionResistance * (float)CS.TFC_DAMAGE_MULTIPLIER);
            }
            this.field_77280_f = 1.0f;
        }

        public void func_77279_a(boolean aEffects) {
            this.mWorld.func_72908_a(this.field_77284_b, this.field_77285_c, this.field_77282_d, "random.explode", 4.0f, (1.0f + (CS.RNGSUS.nextFloat() - CS.RNGSUS.nextFloat()) * 0.2f) * 0.7f);
            if (this.field_77280_f >= 2.0f && this.field_82755_b) {
                this.mWorld.func_72869_a("hugeexplosion", this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            } else {
                this.mWorld.func_72869_a("largeexplode", this.field_77284_b, this.field_77285_c, this.field_77282_d, 1.0, 0.0, 0.0);
            }
            if (this.field_82755_b) {
                for (ChunkPosition tCoords : this.field_77281_g) {
                    int i = tCoords.field_151329_a;
                    int j = tCoords.field_151327_b;
                    int k = tCoords.field_151328_c;
                    Block tBlock = this.mWorld.func_147439_a(i, j, k);
                    if (aEffects) {
                        double d0 = (float)i + CS.RNGSUS.nextFloat();
                        double d1 = (float)j + CS.RNGSUS.nextFloat();
                        double d2 = (float)k + CS.RNGSUS.nextFloat();
                        double d3 = d0 - this.field_77284_b;
                        double d4 = d1 - this.field_77285_c;
                        double d5 = d2 - this.field_77282_d;
                        double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                        d3 /= d6;
                        d4 /= d6;
                        d5 /= d6;
                        double d7 = 0.5 / (d6 / (double)this.field_77280_f + 0.1);
                        this.mWorld.func_72869_a("explode", (d0 + this.field_77284_b) / 2.0, (d1 + this.field_77285_c) / 2.0, (d2 + this.field_77282_d) / 2.0, d3 *= (d7 *= (double)(CS.RNGSUS.nextFloat() * CS.RNGSUS.nextFloat()) + 0.3), d4 *= d7, d5 *= d7);
                        this.mWorld.func_72869_a("smoke", d0, d1, d2, d3, d4, d5);
                    }
                    if (tBlock.func_149688_o() == Material.field_151579_a) continue;
                    byte tMeta = WD.meta((IBlockAccess)this.mWorld, i, j, k);
                    tBlock.onBlockExploded(this.mWorld, i, j, k, (Explosion)this);
                    if (!tBlock.func_149659_a((Explosion)this)) continue;
                    tBlock.func_149690_a(this.mWorld, i, j, k, (int)tMeta, 1.0f, (int)this.mFortune);
                }
            }
        }
    }
}

