/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.gui.ContainerClient;
import gregapi.gui.ContainerCommon;
import gregapi.gui.Slot_Normal;
import gregapi.item.bumble.IItemBumbleBee;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.machines.ITileEntityRunningSuccessfully;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityBumbliary
extends TileEntityBase07Paintable
implements IMultiTileEntity.IMTE_AddToolTips,
ITileEntityRunningSuccessfully {
    public boolean mSky = false;
    public boolean mEndedQueen = false;
    public long mLife = 0L;
    public long mBreedingCountDown = 0L;
    public long mTemperature = 293L;
    public float mHumidity = 1.0f;
    public ItemStack[] mOffSpring = CS.ZL_IS;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/bumbliary/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/bumbliary/colored/top"), new Textures.BlockIcons.CustomIcon("machines/tools/bumbliary/colored/sides")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/tools/bumbliary/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/tools/bumbliary/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/tools/bumbliary/overlay/sides")};
    public static final int SLOT_ROYAL = 13;
    public static final int SLOT_DRONE = 22;
    public static final int[] SLOTS_COMBS = new int[]{0, 1, 2, 6, 7, 8, 9, 10, 11, 15, 16, 17, 18, 19, 20, 24, 25, 26};
    public static final int[] SLOTS_DRONE = new int[]{3, 4, 5, 12, 14, 21, 23};
    public static final int[] SLOTS_DEAD = new int[]{27, 28, 29, 30, 31, 32, 33, 34, 35};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.progress")) {
            this.mLife = aNBT.func_74763_f("gt.progress");
        }
        if (aNBT.func_74764_b("gt.cooldown")) {
            this.mBreedingCountDown = aNBT.func_74763_f("gt.cooldown");
        }
        if (aNBT.func_74764_b("gt.invout")) {
            this.mOffSpring = new ItemStack[aNBT.func_74762_e("gt.invout")];
            for (int i = 0; i < this.mOffSpring.length; ++i) {
                this.mOffSpring[i] = ST.load(aNBT, "gt.invout." + i);
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.progress", this.mLife);
        UT.NBT.setNumber(aNBT, "gt.cooldown", this.mBreedingCountDown);
        if (this.mOffSpring.length > 0) {
            UT.NBT.setNumber(aNBT, "gt.invout", this.mOffSpring.length);
            for (int i = 0; i < this.mOffSpring.length; ++i) {
                ST.save(aNBT, "gt.invout." + i, this.mOffSpring[i]);
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.scoop.to.access"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.thermometer.to.measure"));
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        if (aIsServerSide) {
            for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                if (!this.getRainAtSide(tSide)) continue;
                this.mSky = true;
                break;
            }
            this.mTemperature = WD.envTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.mHumidity = this.getBiome().field_76751_G;
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.mEndedQueen = false;
            if (CS.SERVER_TIME % 1200L == 0L) {
                for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                    if (!this.getRainAtSide(tSide)) continue;
                    this.mSky = true;
                    break;
                }
                this.mTemperature = WD.envTemp(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.mHumidity = this.getBiome().field_76751_G;
            }
            if (this.slotHas(13) && this.slot(13).func_77973_b() instanceof IItemBumbleBee) {
                ItemStack tRoyalStack = this.slot(13);
                IItemBumbleBee tRoyalItem = (IItemBumbleBee)tRoyalStack.func_77973_b();
                NBTTagCompound tRoyalTag = IItemBumbleBee.Util.getBumbleTag(tRoyalStack);
                short tRoyalMeta = ST.meta_(tRoyalStack);
                if (this.mLife > 0L && tRoyalItem.bumbleType(tRoyalStack) % 5 == 2) {
                    this.mBreedingCountDown = 1200L;
                    if (this.checkEnvironment(tRoyalTag)) {
                        if (--this.mLife <= 0L) {
                            int n;
                            this.mEndedQueen = true;
                            for (int tDeadSlot : SLOTS_DEAD) {
                                if (!this.slotHas(tDeadSlot) || !(this.slot(tDeadSlot).func_77973_b() instanceof IItemBumbleBee)) continue;
                                this.slotKill(tDeadSlot);
                            }
                            ItemStack tDead = tRoyalItem.bumbleKill(tRoyalStack);
                            this.slotKill(13);
                            for (int tDeadSlot : SLOTS_DEAD) {
                                if (this.addStackToSlot(tDeadSlot, tDead)) break;
                            }
                            for (int tDroneSlot : SLOTS_DRONE) {
                                if (!this.slotHas(tDroneSlot) || !(this.slot(tDroneSlot).func_77973_b() instanceof IItemBumbleBee)) continue;
                                tDead = ((IItemBumbleBee)this.slot(tDroneSlot).func_77973_b()).bumbleKill(this.slotTake(tDroneSlot));
                                for (int tDeadSlot : SLOTS_DEAD) {
                                    if (this.addStackToSlot(tDeadSlot, tDead)) break;
                                }
                            }
                            for (ItemStack tOffSpring : this.mOffSpring) {
                                if (!ST.valid(tOffSpring) || !(tOffSpring.func_77973_b() instanceof IItemBumbleBee)) continue;
                                if (this.checkEnvironment(IItemBumbleBee.Util.getBumbleTag(tOffSpring))) {
                                    if (this.slotHas(22) && this.addStackToSlot(22, tOffSpring)) continue;
                                    for (int tDroneSlot : SLOTS_DRONE) {
                                        if (this.addStackToSlot(tDroneSlot, tOffSpring)) break;
                                    }
                                    continue;
                                }
                                tDead = ((IItemBumbleBee)tOffSpring.func_77973_b()).bumbleKill(tOffSpring);
                                for (int tDeadSlot : SLOTS_DEAD) {
                                    if (this.addStackToSlot(tDeadSlot, tDead)) break;
                                }
                            }
                            this.mOffSpring = CS.ZL_IS;
                            int n2 = -1;
                            for (int tDroneSlot : SLOTS_DRONE) {
                                if (!this.slotHas(tDroneSlot) || !(this.slot(tDroneSlot).func_77973_b() instanceof IItemBumbleBee) || ((IItemBumbleBee)this.slot(tDroneSlot).func_77973_b()).bumbleType(this.slot(tDroneSlot)) % 5 != 1) continue;
                                if (n < 0) {
                                    n = tDroneSlot;
                                    continue;
                                }
                                if (IItemBumbleBee.Util.getAggressiveness(IItemBumbleBee.Util.getBumbleTag(this.slot(tDroneSlot))) <= IItemBumbleBee.Util.getAggressiveness(IItemBumbleBee.Util.getBumbleTag(this.slot(n)))) continue;
                                n = tDroneSlot;
                            }
                            if (n >= 0) {
                                this.slot(13, ST.amount(1L, this.slot(n)));
                                this.func_70298_a(n, 1);
                            }
                        } else {
                            if (this.mLife % 300L == 150L && (long)this.rng(10000) < IItemBumbleBee.Util.getAggressiveness(tRoyalTag)) {
                                try {
                                    for (EntityLivingBase entityLivingBase : (ArrayList)this.field_145850_b.func_72872_a(EntityLivingBase.class, this.box(-4.0, -4.0, -4.0, 5.0, 5.0, 5.0))) {
                                        this.attackEntity(entityLivingBase);
                                    }
                                }
                                catch (Throwable e) {
                                    e.printStackTrace(CS.ERR);
                                }
                            }
                            if (this.mLife % 1200L == 600L && (long)this.rng(10000) < IItemBumbleBee.Util.getWorkForce(tRoyalTag) && this.checkWork(tRoyalTag) && null != tRoyalItem.bumbleCanProduce(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, tRoyalStack, tRoyalMeta, 3)) {
                                int n = tRoyalItem.bumbleProductCount(tRoyalStack, tRoyalMeta);
                                block24: for (int i = 0; i < n; ++i) {
                                    if (this.rng(10000) >= tRoyalItem.bumbleProductChance(tRoyalStack, tRoyalMeta, i) || null == tRoyalItem.bumbleCanProduct(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, tRoyalStack, tRoyalMeta, i)) continue;
                                    ItemStack tProduct = tRoyalItem.bumbleProductStack(tRoyalStack, tRoyalMeta, 1L, i);
                                    if (ST.valid(tProduct)) {
                                        for (int tSlot : SLOTS_COMBS) {
                                            if (!ST.equal(tProduct, this.slot(tSlot)) || !this.addStackToSlot(tSlot, tProduct)) continue;
                                            tProduct = CS.NI;
                                            break;
                                        }
                                    }
                                    if (!ST.valid(tProduct)) continue;
                                    for (int tSlot : SLOTS_COMBS) {
                                        if (!this.addStackToSlot(tSlot, tProduct)) continue;
                                        tProduct = CS.NI;
                                        continue block24;
                                    }
                                }
                            }
                        }
                    } else {
                        ItemStack tDead = tRoyalItem.bumbleKill(tRoyalStack);
                        this.slotKill(13);
                        for (int tDeadSlot : SLOTS_DEAD) {
                            if (this.addStackToSlot(tDeadSlot, tDead)) break;
                        }
                    }
                } else {
                    this.mLife = 0L;
                    this.mOffSpring = CS.ZL_IS;
                    if (tRoyalItem.bumbleType(tRoyalStack) % 5 == 1) {
                        if (--this.mBreedingCountDown <= 0L) {
                            int n;
                            this.mBreedingCountDown = 600L;
                            ItemStack tBreedStack = null;
                            int n3 = 22;
                            if (this.slotHas(22) && this.slot(22).func_77973_b() instanceof IItemBumbleBee && ((IItemBumbleBee)this.slot(22).func_77973_b()).bumbleType(this.slot(22)) % 5 == 0) {
                                tBreedStack = this.slot(22);
                            } else {
                                for (int tDroneSlot : SLOTS_DRONE) {
                                    ItemStack tDroneStack;
                                    if (!this.slotHas(tDroneSlot) || !(this.slot(tDroneSlot).func_77973_b() instanceof IItemBumbleBee) || ((IItemBumbleBee)(tDroneStack = this.slot(tDroneSlot)).func_77973_b()).bumbleType(tDroneStack) % 5 != 0) continue;
                                    tBreedStack = tDroneStack;
                                    n = tDroneSlot;
                                    if (tRoyalItem.bumbleEqual(tRoyalStack, tRoyalMeta, tDroneStack, ST.meta_(tDroneStack))) break;
                                }
                            }
                            if (tBreedStack != null) {
                                int i;
                                this.mBreedingCountDown = 1200L;
                                IItemBumbleBee tBreedItem = (IItemBumbleBee)tBreedStack.func_77973_b();
                                short tBreedMeta = ST.meta_(tBreedStack);
                                int tPrincessCount = 1 + this.rng(5) / 2;
                                this.mOffSpring = new ItemStack[(int)IItemBumbleBee.Util.getOffspring(tRoyalTag) + tPrincessCount];
                                if (tRoyalItem.bumbleEqual(tRoyalStack, tRoyalMeta, tBreedStack, tBreedMeta)) {
                                    for (i = 0; i < this.mOffSpring.length; ++i) {
                                        ItemStack itemStack = this.mOffSpring[i] = i < tPrincessCount ? tRoyalItem.bumblePrincess(tRoyalStack, tRoyalMeta) : tRoyalItem.bumbleDrone(tRoyalStack, tRoyalMeta);
                                        if (!ST.valid(this.mOffSpring[i]) || !(this.mOffSpring[i].func_77973_b() instanceof IItemBumbleBee)) continue;
                                        IItemBumbleBee tOffSpringItem = (IItemBumbleBee)this.mOffSpring[i].func_77973_b();
                                        if (this.rng(10000) >= tOffSpringItem.bumbleMutateChance(this.mOffSpring[i], ST.meta_(this.mOffSpring[i]))) continue;
                                        this.mOffSpring[i] = tOffSpringItem.bumbleMutate(this.mOffSpring[i], ST.meta_(this.mOffSpring[i]), CS.RNGSUS);
                                    }
                                } else {
                                    block30: for (i = 0; i < this.mOffSpring.length; ++i) {
                                        if (i < tPrincessCount) {
                                            switch (this.rng(4)) {
                                                case 0: {
                                                    this.mOffSpring[i] = tRoyalItem.bumblePrincess(tRoyalStack, tRoyalMeta);
                                                    break;
                                                }
                                                case 1: {
                                                    this.mOffSpring[i] = tBreedItem.bumblePrincess(tBreedStack, tBreedMeta);
                                                    break;
                                                }
                                                case 2: {
                                                    this.mOffSpring[i] = tRoyalItem.bumbleCombine(tRoyalStack, tRoyalMeta, tBreedStack, tBreedMeta, (byte)1, CS.RNGSUS);
                                                    break;
                                                }
                                                case 3: {
                                                    this.mOffSpring[i] = tBreedItem.bumbleCombine(tBreedStack, tBreedMeta, tRoyalStack, tRoyalMeta, (byte)1, CS.RNGSUS);
                                                }
                                            }
                                            continue;
                                        }
                                        switch (this.rng(4)) {
                                            case 0: {
                                                this.mOffSpring[i] = tRoyalItem.bumbleDrone(tRoyalStack, tRoyalMeta);
                                                continue block30;
                                            }
                                            case 1: {
                                                this.mOffSpring[i] = tBreedItem.bumbleDrone(tBreedStack, tBreedMeta);
                                                continue block30;
                                            }
                                            case 2: {
                                                this.mOffSpring[i] = tRoyalItem.bumbleCombine(tRoyalStack, tRoyalMeta, tBreedStack, tBreedMeta, (byte)0, CS.RNGSUS);
                                                continue block30;
                                            }
                                            case 3: {
                                                this.mOffSpring[i] = tBreedItem.bumbleCombine(tBreedStack, tBreedMeta, tRoyalStack, tRoyalMeta, (byte)0, CS.RNGSUS);
                                            }
                                        }
                                    }
                                }
                                for (ItemStack tOffSpring : this.mOffSpring) {
                                    if (!ST.valid(tOffSpring)) continue;
                                    IItemBumbleBee.Util.setBumbleTag(tOffSpring, IItemBumbleBee.Util.getBumbleGenes(tRoyalStack, tBreedStack, CS.RNGSUS));
                                }
                                this.mLife = IItemBumbleBee.Util.getLifeSpan(tRoyalTag);
                                int tLoss = n == 22 && tBreedStack.field_77994_a > 1 ? 2 : 1;
                                ItemStack tDead = tBreedItem.bumbleKill(ST.amount(tLoss, tBreedStack));
                                for (int tDeadSlot : SLOTS_DEAD) {
                                    if (this.addStackToSlot(tDeadSlot, tDead)) break;
                                }
                                this.func_70298_a(n, tLoss);
                                this.slot(13, ST.amount(1L, tRoyalItem.bumbleCrown(tRoyalStack)));
                                for (int tDroneSlot : SLOTS_DRONE) {
                                    if (!this.slotHas(tDroneSlot) || !(this.slot(tDroneSlot).func_77973_b() instanceof IItemBumbleBee) || ((IItemBumbleBee)this.slot(tDroneSlot).func_77973_b()).bumbleType(this.slot(tDroneSlot)) % 5 == 0) continue;
                                    tDead = ((IItemBumbleBee)this.slot(tDroneSlot).func_77973_b()).bumbleKill(this.slotTake(tDroneSlot));
                                    for (int tDeadSlot : SLOTS_DEAD) {
                                        if (this.addStackToSlot(tDeadSlot, tDead)) break;
                                    }
                                }
                            }
                        }
                    } else {
                        this.mBreedingCountDown = 1200L;
                    }
                }
            } else {
                this.mLife = 0L;
                this.mOffSpring = CS.ZL_IS;
                this.mBreedingCountDown = 1200L;
            }
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (CS.SIDES_TOP[aSide]) {
            if (aPlayer != null && this.isServerSide()) {
                if (UT.Entities.isCreative(aPlayer)) {
                    this.openGUI(aPlayer, 1);
                    return true;
                }
                this.mBreedingCountDown = 6000L;
                this.attackEntity((EntityLivingBase)aPlayer);
                this.openGUI(aPlayer, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + this.mTemperature + "K - Humidity: " + this.mHumidity);
            }
            return 1000L;
        }
        if (aTool.equals("scoop")) {
            if (CS.SIDES_TOP[aSide]) {
                this.mBreedingCountDown = 6000L;
                if (aPlayer instanceof EntityLivingBase) {
                    this.attackEntity((EntityLivingBase)aPlayer);
                }
                if (aPlayer instanceof EntityPlayer) {
                    this.openGUI((EntityPlayer)aPlayer, 1);
                }
                return 10000L;
            }
            return 0L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[CS.FACES_TBS[aSide]], this.mRGBa), BlockTextureDefault.get(sOverlays[CS.FACES_TBS[aSide]])) : null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object getGUIClient2(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID == 1 ? new MultiTileEntityGUIClientBumbliaryScoop(aPlayer.field_71071_by, this, aGUIID) : new MultiTileEntityGUIClientBumbliary(aPlayer.field_71071_by, this, aGUIID);
    }

    @Override
    public Object getGUIServer2(int aGUIID, EntityPlayer aPlayer) {
        return aGUIID == 1 ? new MultiTileEntityGUICommonBumbliaryScoop(aPlayer.field_71071_by, this, aGUIID) : new MultiTileEntityGUICommonBumbliary(aPlayer.field_71071_by, this, aGUIID);
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[36];
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return SLOTS_DEAD;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return aSlot == 13 ? 1 : 64;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot >= 27;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide];
    }

    @Override
    public boolean canDrop(int aSlot) {
        return true;
    }

    @Override
    public boolean breakDrop(int aSlot) {
        if (this.mLife > 0L && this.slot(aSlot).func_77973_b() instanceof IItemBumbleBee) {
            this.slot(aSlot, ((IItemBumbleBee)this.slot(aSlot).func_77973_b()).bumbleKill(this.slot(aSlot)));
        }
        return true;
    }

    @Override
    public boolean isFireProof(byte aSide) {
        return true;
    }

    @Override
    public boolean isRainProof(byte aSide) {
        return true;
    }

    @Override
    public boolean isWaterProof(byte aSide) {
        return true;
    }

    @Override
    public boolean isThunderProof(byte aSide) {
        return true;
    }

    @Override
    public boolean getStateRunningActively() {
        return this.mLife > 0L;
    }

    @Override
    public boolean getStateRunningPassively() {
        return this.mLife > 0L || this.mBreedingCountDown < 1200L;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mLife > 0L || this.mBreedingCountDown < 1200L;
    }

    @Override
    public boolean getStateRunningSuccessfully() {
        return this.mEndedQueen;
    }

    @Override
    public boolean isItemValidForSlotGUI(int aSlot, ItemStack aStack) {
        if (ST.invalid(aStack) || !(aStack.func_77973_b() instanceof IItemBumbleBee)) {
            return false;
        }
        switch (aSlot) {
            case 22: {
                return ((IItemBumbleBee)aStack.func_77973_b()).bumbleType(aStack) % 5 == 0;
            }
            case 13: {
                return ((IItemBumbleBee)aStack.func_77973_b()).bumbleType(aStack) % 5 == 1;
            }
        }
        return false;
    }

    @Override
    public boolean canTakeOutOfSlotGUI(int aSlot) {
        return aSlot != 13 || !this.slotHas(aSlot) || !(this.slot(aSlot).func_77973_b() instanceof IItemBumbleBee) || ((IItemBumbleBee)this.slot(aSlot).func_77973_b()).bumbleType(this.slot(aSlot)) % 5 != 2;
    }

    private boolean attackEntity(EntityLivingBase aEntity) {
        return this.slotHas(13) && this.slot(13).func_77973_b() instanceof IItemBumbleBee && ((IItemBumbleBee)this.slot(13).func_77973_b()).bumbleType(this.slot(13)) % 5 == 2 && ((IItemBumbleBee)this.slot(13).func_77973_b()).bumbleAttack(this.slot(13), ST.meta_(this.slot(13)), aEntity);
    }

    private boolean checkEnvironment(NBTTagCompound aBumbleTag) {
        return UT.Code.inside(IItemBumbleBee.Util.getTemperatureMin(aBumbleTag), IItemBumbleBee.Util.getTemperatureMax(aBumbleTag), this.mTemperature) && UT.Code.inside_(IItemBumbleBee.Util.getHumidityMin(aBumbleTag), IItemBumbleBee.Util.getHumidityMax(aBumbleTag), this.mHumidity) && (this.mSky ? IItemBumbleBee.Util.getOutsideActive(aBumbleTag) : IItemBumbleBee.Util.getInsideActive(aBumbleTag));
    }

    private boolean checkWork(NBTTagCompound aBumbleTag) {
        if (this.mSky) {
            if (this.field_145850_b.func_72911_I() && !IItemBumbleBee.Util.getStormproof(aBumbleTag)) {
                return false;
            }
            if (this.field_145850_b.func_72896_J() && this.mHumidity > 0.0f && !IItemBumbleBee.Util.getRainproof(aBumbleTag)) {
                return false;
            }
        }
        return this.field_145850_b.func_72935_r() ? IItemBumbleBee.Util.getDayActive(aBumbleTag) : IItemBumbleBee.Util.getNightActive(aBumbleTag);
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.bumbliary";
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientBumbliaryScoop
    extends ContainerClient {
        public MultiTileEntityGUIClientBumbliaryScoop(InventoryPlayer aInventoryPlayer, MultiTileEntityBumbliary aTileEntity, int aGUIID) {
            super(new MultiTileEntityGUICommonBumbliaryScoop(aInventoryPlayer, aTileEntity, aGUIID), CS.RES_PATH_GUI + "machines/Bumbliary.png");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class MultiTileEntityGUIClientBumbliary
    extends ContainerClient {
        public MultiTileEntityGUIClientBumbliary(InventoryPlayer aInventoryPlayer, MultiTileEntityBumbliary aTileEntity, int aGUIID) {
            super(new MultiTileEntityGUICommonBumbliary(aInventoryPlayer, aTileEntity, aGUIID), CS.RES_PATH_GUI + "machines/Bumbliary.png");
        }
    }

    public class MultiTileEntityGUICommonBumbliaryScoop
    extends ContainerCommon {
        public MultiTileEntityGUICommonBumbliaryScoop(InventoryPlayer aInventoryPlayer, MultiTileEntityBumbliary aTileEntity, int aGUIID) {
            super(aInventoryPlayer, aTileEntity, aGUIID);
        }

        @Override
        public int addSlots(InventoryPlayer aInventoryPlayer) {
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 0, 8, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 1, 26, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 2, 44, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 3, 62, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 4, 80, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 5, 98, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 6, 116, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 7, 134, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 8, 152, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 9, 8, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 10, 26, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 11, 44, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 12, 62, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 13, 80, 26));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 14, 98, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 15, 116, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 16, 134, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 17, 152, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 18, 8, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 19, 26, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 20, 44, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 21, 62, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 22, 80, 44));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 23, 98, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 24, 116, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 25, 134, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 26, 152, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 27, 8, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 28, 26, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 29, 44, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 30, 62, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 31, 80, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 32, 98, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 33, 116, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 34, 134, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 35, 152, 62).setCanPut(false));
            return super.addSlots(aInventoryPlayer);
        }

        @Override
        public int getSlotCount() {
            return 36;
        }

        @Override
        public int getShiftClickSlotCount() {
            return 36;
        }
    }

    public class MultiTileEntityGUICommonBumbliary
    extends ContainerCommon {
        public MultiTileEntityGUICommonBumbliary(InventoryPlayer aInventoryPlayer, MultiTileEntityBumbliary aTileEntity, int aGUIID) {
            super(aInventoryPlayer, aTileEntity, aGUIID);
        }

        @Override
        public int addSlots(InventoryPlayer aInventoryPlayer) {
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 0, 8, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 1, 26, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 2, 44, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 3, 62, 8).setCanPut(false).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 4, 80, 8).setCanPut(false).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 5, 98, 8).setCanPut(false).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 6, 116, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 7, 134, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 8, 152, 8).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 9, 8, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 10, 26, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 11, 44, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 12, 62, 26).setCanPut(false).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 13, 80, 26).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 14, 98, 26).setCanPut(false).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 15, 116, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 16, 134, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 17, 152, 26).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 18, 8, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 19, 26, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 20, 44, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 21, 62, 44).setCanPut(false).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 22, 80, 44).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 23, 98, 44).setCanPut(false).setCanTake(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 24, 116, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 25, 134, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 26, 152, 44).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 27, 8, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 28, 26, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 29, 44, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 30, 62, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 31, 80, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 32, 98, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 33, 116, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 34, 134, 62).setCanPut(false));
            this.func_75146_a(new Slot_Normal(this.mTileEntity, 35, 152, 62).setCanPut(false));
            return super.addSlots(aInventoryPlayer);
        }

        @Override
        public int getSlotCount() {
            return 36;
        }

        @Override
        public int getShiftClickSlotCount() {
            return 36;
        }
    }
}

