/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tanks;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityTapFillable;
import gregapi.tileentity.tank.TileEntityBase10FluidContainerSyncSmall;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityCell
extends TileEntityBase10FluidContainerSyncSmall
implements ITileEntityTapFillable,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing {
    public ITexture[] mTextures = new ITexture[3];
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/colored/sides");
    public static IIconContainer sTextureInsides = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/colored/insides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/colored/bottom");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/overlay/sides");
    public static IIconContainer sOverlayInsides = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/overlay/insides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tanks/cell/overlay/bottom");

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTextures[0] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayBottom));
        this.mTextures[1] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayTop));
        this.mTextures[2] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayInsides), BlockTextureFluid.get(this.mTank), BlockTextureDefault.get(sTextureSides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlaySides));
        return 3;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[1], CS.PX_P[6], CS.PX_N[5], CS.PX_N[5], CS.PX_N[6]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[1], CS.PX_P[5], CS.PX_N[6], CS.PX_N[5], CS.PX_N[5]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[4], CS.PX_N[6]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return this.mTextures[CS.FACES_TBS[aSide]];
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[5], CS.PX_P[0], CS.PX_P[5], CS.PX_N[5], CS.PX_N[4], CS.PX_N[5]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[5], CS.PX_P[0], CS.PX_P[5], CS.PX_N[5], CS.PX_N[4], CS.PX_N[5]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[5], CS.PX_N[5], CS.PX_N[4], CS.PX_N[5]);
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.0f : CS.PX_P[5];
    }

    @Override
    public byte getMaxStackSize(ItemStack aStack, byte aDefault) {
        return aDefault;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.cell";
    }
}

