/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.connectors.MultiTileEntityAxle;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import gregtech.tileentity.energy.transformers.MultiTileEntityGearBox;
import net.minecraft.tileentity.TileEntity;

public class MultiTileEntityTachometer
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.tachometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof MultiTileEntityAxle) {
            return ((MultiTileEntityAxle)aDelegator.mTileEntity).mTransferredLast;
        }
        if (aDelegator.mTileEntity instanceof MultiTileEntityGearBox) {
            return ((MultiTileEntityGearBox)aDelegator.mTileEntity).mTransferredLast;
        }
        return 0L;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        if (aDelegator.mTileEntity instanceof MultiTileEntityAxle) {
            return ((MultiTileEntityAxle)aDelegator.mTileEntity).mPower * ((MultiTileEntityAxle)aDelegator.mTileEntity).mSpeed;
        }
        if (aDelegator.mTileEntity instanceof MultiTileEntityGearBox) {
            return ((MultiTileEntityGearBox)aDelegator.mTileEntity).mMaxThroughPut * 16L;
        }
        return 0L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_GREEN_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_RU;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.tachometer";
    }

    static {
        LH.add("gt.tooltip.sensor.tachometer", "Measures Axle Rotations (In RU)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tachometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tachometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tachometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tachometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tachometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/tachometer/overlay/side");
    }
}

