/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.converters;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityAcceptor;
import gregapi.tileentity.energy.TileEntityBase10EnergyConverter;
import gregapi.tileentity.machines.ITileEntityAdjacentOnOff;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityHeaterElectric
extends TileEntityBase10EnergyConverter
implements ITileEntityEnergyElectricityAcceptor,
ITileEntityAdjacentOnOff,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_OnEntityCollidedWithBlock,
ITileEntitySwitchableMode {
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/colored/front"), new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/colored/back"), new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/overlay/side")};
    public static IIconContainer[] sOverlaysActive = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/overlay_active/front"), new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/overlay_active/back"), new Textures.BlockIcons.CustomIcon("machines/heaters/heat_electric/overlay_active/side")};

    @Override
    public void onEntityCollidedWithBlock(Entity aEntity) {
        if (this.mActivity.mState > 0) {
            UT.Entities.applyHeatDamage(aEntity, Math.min(10.0f, (float)this.mConverter.mEnergyOUT.mRec / 10.0f));
        }
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(this.mFacing == 4 ? CS.PX_P[2] : 0.0f, this.mFacing == 0 ? CS.PX_P[2] : 0.0f, this.mFacing == 2 ? CS.PX_P[2] : 0.0f, this.mFacing == 5 ? CS.PX_N[2] : 1.0f, this.mFacing == 1 ? CS.PX_N[2] : 1.0f, this.mFacing == 3 ? CS.PX_N[2] : 1.0f);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact") + " (" + LH.get("gt.lang.face.front") + ")");
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa), BlockTextureDefault.get((this.mActivity.mState > 0 ? sOverlaysActive : sOverlays)[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.heater.heat_electric";
    }
}

