/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import com.mojang.authlib.GameProfile;
import gregapi.block.misc.BlockBaseBars;
import gregapi.block.misc.BlockBaseSpike;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.enchants.Enchantment_EnderDamage;
import gregapi.item.IItemProjectile;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.misc.MultiTileEntityGregOLantern;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.potion.Potion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import twilightforest.entity.boss.EntityTFLich;

public class Behavior_Gun
extends IBehavior.AbstractBehaviorDefault {
    public static Behavior_Gun BULLETS_SMALL = new Behavior_Gun(TD.Projectiles.BULLET_SMALL, 1.0f, 10000L, 16L);
    public static Behavior_Gun BULLETS_MEDIUM = new Behavior_Gun(TD.Projectiles.BULLET_MEDIUM, 2.0f, 17500L, 8L);
    public static Behavior_Gun BULLETS_LARGE = new Behavior_Gun(TD.Projectiles.BULLET_LARGE, 3.0f, 25000L, 4L);
    public final TagData mBulletType;
    public final long mPower;
    public final float mMagic;
    public final byte mAmmoPerMag;

    public Behavior_Gun(TagData aBulletType, float aMagic, long aPower, long aAmmoPerMag) {
        this.mBulletType = aBulletType;
        this.mMagic = aMagic;
        this.mPower = aPower;
        this.mAmmoPerMag = UT.Code.bindStack(aAmmoPerMag);
    }

    public boolean shoot(ItemStack aGun, ItemStack aBullet, EntityPlayer aPlayer) {
        ChunkCoordinates oCoord;
        aGun = ST.update(aGun, (Entity)aPlayer);
        aBullet = ST.update(aBullet, (Entity)aPlayer);
        Vec3 tDir = aPlayer.func_70040_Z();
        Vec3 tPos = Vec3.func_72443_a((double)aPlayer.field_70165_t, (double)(aPlayer.field_70163_u + (double)aPlayer.func_70047_e()), (double)aPlayer.field_70161_v);
        Vec3 tAim = tPos.func_72441_c(tDir.field_72450_a * 200.0, tDir.field_72448_b * 200.0, tDir.field_72449_c * 200.0);
        List<ChunkCoordinates> aCoords = WD.line(tPos, tAim);
        ChunkCoordinates aCoord = oCoord = aCoords.get(0);
        ChunkCoordinates nCoord = oCoord;
        Block oBlock = CS.NB;
        Block aBlock = oBlock = WD.block((IBlockAccess)aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c);
        byte oMeta = 0;
        byte aMeta = oMeta = WD.meta((IBlockAccess)aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c);
        boolean tWater = WD.liquid(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c);
        int tFireAspect = UT.NBT.getEnchantmentLevel(Enchantment.field_77343_v, aGun) + UT.NBT.getEnchantmentLevel(Enchantment.field_77334_n, aBullet);
        List tEntities = aPlayer.field_70170_p.func_72839_b((Entity)aPlayer, AxisAlignedBB.func_72330_a((double)(Math.min(tPos.field_72450_a, tAim.field_72450_a) - 2.0), (double)(Math.min(tPos.field_72448_b, tAim.field_72448_b) - 2.0), (double)(Math.min(tPos.field_72449_c, tAim.field_72449_c) - 2.0), (double)(Math.max(tPos.field_72450_a, tAim.field_72450_a) + 2.0), (double)(Math.max(tPos.field_72448_b, tAim.field_72448_b) + 2.0), (double)(Math.max(tPos.field_72449_c, tAim.field_72449_c) + 2.0)));
        ArrayListNoNulls<Entity> tTargets = new ArrayListNoNulls<Entity>();
        for (Object tEntity : tEntities) {
            AxisAlignedBB tBox;
            if (!(tEntity instanceof Entity) || (tBox = ((Entity)tEntity).field_70121_D) == null) continue;
            if (tEntity instanceof EntityEnderCrystal) {
                tBox = tBox.func_72325_c(0.0, 1.3, 0.0);
            }
            if (tBox.func_72327_a(tPos, tAim) == null) continue;
            tTargets.add((Entity)tEntity);
        }
        long tPower = this.mPower + 2000L * (long)UT.NBT.getEnchantmentLevel(Enchantment.field_77345_t, aGun);
        int ii = aCoords.size() - 1;
        for (int i = 1; i < ii; ++i) {
            AxisAlignedBB tBox;
            if (tPower <= 0L) {
                if (tFireAspect > 2) {
                    WD.burn(aPlayer.field_70170_p, oCoord, true, true);
                }
                return true;
            }
            oCoord = aCoords.get(i - 1);
            aCoord = aCoords.get(i);
            nCoord = aCoords.get(i + 1);
            oBlock = aBlock;
            oMeta = aMeta;
            aBlock = WD.block((IBlockAccess)aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c);
            aMeta = WD.meta((IBlockAccess)aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c);
            for (int j = 0; j < tTargets.size(); ++j) {
                if (!(((Entity)tTargets.get(j)).func_70092_e((double)aCoord.field_71574_a + 0.5, (double)aCoord.field_71572_b + 0.5, (double)aCoord.field_71573_c + 0.5) < ((Entity)tTargets.get(j)).func_70092_e((double)nCoord.field_71574_a + 0.5, (double)nCoord.field_71572_b + 0.5, (double)nCoord.field_71573_c + 0.5)) || !this.hit(aGun, aBullet, aPlayer, (Entity)tTargets.remove(j--), tPower, tDir) || (tPower -= 10000L) > 0L) continue;
                return true;
            }
            if (WD.liquid(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c)) {
                if (tWater) continue;
                tWater = true;
                UT.Sounds.send("game.neutral.swim", aPlayer.field_70170_p, aCoord);
                if (tPower > 10000L) {
                    tPower = 0L;
                    continue;
                }
                tPower /= 2L;
                continue;
            }
            tWater = false;
            if (aBlock instanceof BlockPumpkin || WD.te(aPlayer.field_70170_p, aCoord, true) instanceof MultiTileEntityGregOLantern) {
                if (CS.RNGSUS.nextInt(3) == 0) {
                    ST.drop(aPlayer.field_70170_p, (double)aCoord.field_71574_a + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.field_71572_b + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.field_71573_c + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Blocks.field_150423_aK, 1L, 0L));
                } else {
                    ST.drop(aPlayer.field_70170_p, (double)aCoord.field_71574_a + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.field_71572_b + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.field_71573_c + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Items.field_151080_bb, (long)(1 + CS.RNGSUS.nextInt(3)), 0L));
                }
                WD.set(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.field_70170_p, aCoord, false);
                }
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower -= 3000L;
                continue;
            }
            if (aBlock == Blocks.field_150440_ba) {
                ST.drop(aPlayer.field_70170_p, (double)aCoord.field_71574_a + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.field_71572_b + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.field_71573_c + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Items.field_151127_ba, (long)(1 + CS.RNGSUS.nextInt(6)), 0L));
                ST.drop(aPlayer.field_70170_p, (double)aCoord.field_71574_a + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.field_71572_b + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.field_71573_c + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Items.field_151081_bc, (long)(1 + CS.RNGSUS.nextInt(3)), 0L));
                WD.set(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.field_70170_p, aCoord, false);
                }
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower -= 3000L;
                continue;
            }
            if (aBlock == Blocks.field_150434_aF) {
                ST.drop(aPlayer.field_70170_p, (double)aCoord.field_71574_a + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.field_71572_b + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.field_71573_c + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, ST.make(Blocks.field_150434_aF, 1L, 0L));
                WD.set(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.field_70170_p, aCoord, false);
                }
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower -= 3000L;
                continue;
            }
            if (aBlock == Blocks.field_150375_by) {
                ST.drop(aPlayer.field_70170_p, (double)aCoord.field_71574_a + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.field_71572_b + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.field_71573_c + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, IL.Dye_Cocoa.get(1L, new Object[0]));
                WD.set(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c, CS.NB, 0L, 3L);
                if (tFireAspect > 1) {
                    WD.fire(aPlayer.field_70170_p, aCoord, false);
                }
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower -= 2000L;
                continue;
            }
            if (aBlock == Blocks.field_150325_L || aBlock.func_149688_o() == Material.field_151593_r) {
                if (tFireAspect > 1) {
                    WD.set(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c, CS.NB, 0L, 3L);
                    WD.fire(aPlayer.field_70170_p, aCoord, false);
                }
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower -= 4000L;
                continue;
            }
            if (aBlock.func_149688_o() == Material.field_151592_s || aBlock == Blocks.field_150432_aD || aBlock == Blocks.field_150379_bu || aBlock == Blocks.field_150374_bv) {
                OreDictItemData tData = OM.anydata(ST.make(aBlock, 1L, (long)aMeta));
                for (OreDictMaterialStack tMaterial : tData.getAllMaterialStacks()) {
                    long tAmount = tMaterial.mAmount / OP.scrapGt.mAmount;
                    while (tAmount-- > 0L) {
                        ST.drop(aPlayer.field_70170_p, (double)aCoord.field_71574_a + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, (double)aCoord.field_71572_b + 0.1 + (double)CS.RNGSUS.nextFloat() * 0.5, (double)aCoord.field_71573_c + 0.2 + (double)CS.RNGSUS.nextFloat() * 0.6, OP.scrapGt.mat(tMaterial.mMaterial, 1L));
                    }
                }
                WD.set(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c, CS.NB, 0L, 3L);
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower -= 2000L;
                continue;
            }
            if (aBlock instanceof BlockFence || aBlock instanceof BlockFenceGate || aBlock == Blocks.field_150321_G || aBlock == Blocks.field_150474_ac || aBlock instanceof BlockPane || aBlock instanceof BlockRail || aBlock instanceof BlockTorch || aBlock instanceof BlockBaseBars || aBlock instanceof BlockBaseSpike || aBlock.func_149688_o() == Material.field_151570_A || aBlock.func_149688_o() == Material.field_151581_o || aBlock.func_149688_o() == Material.field_151579_a || aBlock.func_149688_o() == Material.field_151580_n || aBlock.func_149688_o() == Material.field_151584_j || aBlock.func_149688_o() == Material.field_151585_k || aBlock.func_149688_o() == Material.field_151582_l) {
                tPower -= 200L;
                continue;
            }
            if (aBlock instanceof BlockStairs || WD.opq(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c, true, false)) {
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower = 0L;
                continue;
            }
            if ((aBlock.func_149678_a((int)aMeta, false) || aBlock.func_149678_a((int)aMeta, true)) && (tBox = aBlock.func_149668_a(aPlayer.field_70170_p, aCoord.field_71574_a, aCoord.field_71572_b, aCoord.field_71573_c)) != null && tBox.func_72327_a(tPos, tAim) != null) {
                UT.Sounds.send(aBlock.field_149762_H.func_150495_a(), aPlayer.field_70170_p, aCoord);
                tPower = 0L;
                continue;
            }
            tPower -= 200L;
        }
        return false;
    }

    public boolean hit(ItemStack aGun, ItemStack aBullet, EntityPlayer aPlayer, Entity aTarget, long aPower, Vec3 aDir) {
        try {
            if (aTarget.func_85032_ar()) {
                return false;
            }
            if (aTarget instanceof EntityPlayer && (((EntityPlayer)aTarget).field_71075_bZ.field_75102_a || !aPlayer.func_96122_a((EntityPlayer)aTarget))) {
                return false;
            }
            if (aTarget instanceof EntityEnderman && ((EntityEnderman)aTarget).func_70660_b(Potion.field_76437_t) == null && UT.NBT.getEnchantmentLevel((Enchantment)Enchantment_EnderDamage.INSTANCE, aBullet) <= 0) {
                for (int i = 0; i < 64; ++i) {
                    if (!((EntityEnderman)aTarget).func_70820_n()) continue;
                    return false;
                }
            }
            if (!(aTarget instanceof EntityLivingBase || aTarget instanceof EntityDragonPart || aTarget instanceof EntityEnderCrystal)) {
                return false;
            }
            OreDictItemData tData = OM.anydata(aBullet);
            OreDictMaterial tGunMat = MultiItemTool.getPrimaryMaterial(aGun, MT.Steel);
            float tMassFactor = tData != null && tData.nonemptyMaterial() ? (float)tData.mMaterial.weight() / 50.0f : 1.0f;
            float tSpeedFactor = Math.min(2.0f, (float)aPower / 5000.0f);
            float tMagicDamage = aTarget instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)aBullet, (EnumCreatureAttribute)((EntityLivingBase)aTarget).func_70668_bt()) : (aTarget instanceof EntityDragonPart ? (float)UT.NBT.getEnchantmentLevel((Enchantment)Enchantment_EnderDamage.INSTANCE, aBullet) : 0.0f);
            float tDamage = tSpeedFactor * Math.max(0.0f, (float)tGunMat.mToolQuality * 0.5f + tMassFactor);
            int tImplosion = UT.NBT.getEnchantmentLevelImplosion(aBullet);
            int tFireDamage = 4 * (UT.NBT.getEnchantmentLevel(Enchantment.field_77343_v, aGun) + UT.NBT.getEnchantmentLevel(Enchantment.field_77334_n, aBullet));
            int tKnockback = UT.NBT.getEnchantmentLevel(Enchantment.field_77344_u, aGun) + UT.NBT.getEnchantmentLevel(Enchantment.field_77337_m, aBullet);
            if (tImplosion > 0 && UT.Entities.isExplosiveCreature(aTarget)) {
                tMagicDamage += 1.5f * (float)tImplosion;
            }
            if (tFireDamage > 0) {
                aTarget.func_70015_d(tFireDamage);
            }
            EntityPlayer tPlayer = aPlayer;
            if (aTarget instanceof EntityPlayer) {
                tDamage /= 2.0f;
                tMagicDamage /= 2.0f;
            } else {
                tMagicDamage *= this.mMagic;
                if (aPlayer.field_70170_p instanceof WorldServer && UT.NBT.getEnchantmentLevel(Enchantment.field_77335_o, aBullet) > 0) {
                    tPlayer = FakePlayerFactory.get((WorldServer)((WorldServer)aPlayer.field_70170_p), (GameProfile)new GameProfile(new UUID(0L, 0L), aPlayer.func_70005_c_()));
                    tPlayer.field_71071_by.field_70461_c = 0;
                    tPlayer.field_71071_by.func_70299_a(0, aBullet);
                    tPlayer.func_70080_a(aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v, aPlayer.field_70177_z, aPlayer.field_70125_A);
                    if (WD.dimTF(aPlayer.field_70170_p)) {
                        tPlayer.field_71075_bZ.field_75098_d = true;
                    }
                    tPlayer.func_70106_y();
                }
            }
            DamageSource tDamageSource = DamageSources.getCombatDamage("player", (EntityLivingBase)tPlayer, DamageSources.getDeathMessage((EntityLivingBase)aPlayer, aTarget, tData != null && tData.validMaterial() ? "[VICTIM] got killed by [KILLER] shooting a Bullet made of " + tData.mMaterial.mMaterial.getLocal() : "[VICTIM] got shot by [KILLER]"), false).func_76349_b();
            if (aPower > 25000L) {
                tDamageSource.func_76348_h();
            }
            if (MD.TF.mLoaded && aTarget instanceof EntityTFLich && UT.NBT.getEnchantmentLevel(Enchantment.field_77339_k, aBullet) > 0) {
                tDamageSource.func_76348_h();
            }
            if (aTarget.func_70097_a(tDamageSource, (tDamage + tMagicDamage) * (float)CS.TFC_DAMAGE_MULTIPLIER)) {
                int n = aTarget.field_70172_ad = aTarget instanceof EntityLivingBase ? ((EntityLivingBase)aTarget).field_70771_an : 20;
                if (aTarget instanceof EntityCreeper && tFireDamage > 0 && tImplosion <= 0) {
                    ((EntityCreeper)aTarget).func_146079_cb();
                }
                if (tKnockback > 0) {
                    aTarget.func_70024_g(aDir.field_72450_a * (double)tKnockback * (double)aPower / 50000.0, 0.05, aDir.field_72449_c * (double)tKnockback * (double)aPower / 50000.0);
                }
                if (aTarget instanceof EntityLivingBase) {
                    UT.Enchantments.applyBullshitA((EntityLivingBase)aTarget, (Entity)aPlayer, aBullet);
                }
                UT.Enchantments.applyBullshitB((EntityLivingBase)aPlayer, aTarget, aBullet);
                if (aTarget instanceof EntityPlayer && aPlayer instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)aPlayer).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                }
                if (tMagicDamage > 0.0f) {
                    aPlayer.func_71047_c(aTarget);
                }
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            UT.Entities.sendchat((Object)aPlayer, "See gregtech.log for details: " + e.toString());
            aTarget.func_70106_y();
            return true;
        }
        return aTarget.field_70172_ad <= 0;
    }

    @Override
    public boolean onItemUse(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        this.onItemRightClick(aItem, aStack, aPlayer.field_70170_p, aPlayer);
        return true;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aWorld.field_72995_K) {
            return false;
        }
        this.onItemRightClick(aItem, aStack, aPlayer.field_70170_p, aPlayer);
        return true;
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aGun, World aWorld, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return aGun;
        }
        NBTTagCompound aNBT = UT.NBT.getOrCreate(aGun);
        ItemStack aBullet = ST.load(aNBT, "gt.ammo");
        if (aPlayer.func_70093_af()) {
            if (ST.invalid(aBullet) || aBullet.field_77994_a <= 0) {
                this.reloadGun(aGun, aPlayer, false);
                return aGun;
            }
            ST.give((Entity)aPlayer, aBullet);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", CS.NI);
            return aGun;
        }
        if (ST.invalid(aBullet) || aBullet.field_77994_a <= 0) {
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", CS.NI);
            return aGun;
        }
        this.shoot(aGun, ST.amount(1L, aBullet), aPlayer);
        UT.Sounds.send("fireworks.blast_far", 128.0f, (Entity)aPlayer);
        if (!UT.Entities.hasInfiniteItems(aPlayer) && CS.RNGSUS.nextInt(1 + UT.NBT.getEnchantmentLevel(Enchantment.field_77342_w, aGun)) == 0) {
            OreDictItemData tData = OM.anydata(aBullet);
            --aBullet.field_77994_a;
            ST.save(aNBT, "gt.ammo", aBullet.field_77994_a > 0 ? aBullet : CS.NI);
            for (OreDictMaterialStack tMat : tData.mByProducts) {
                if (tMat.mAmount < OP.scrapGt.mAmount || tMat.mMaterial.containsAny(TD.Properties.EXPLOSIVE, TD.Properties.FLAMMABLE)) continue;
                ST.give((Entity)aPlayer, OP.scrapGt.mat(tMat.mMaterial, tMat.mAmount / OP.scrapGt.mAmount));
            }
        }
        ((MultiItemTool)aItem).doDamage(aGun, 100L, (EntityLivingBase)aPlayer, false);
        return aGun;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.Chat.CYAN + LH.get("gt.weapon.sneak.rightclick.reload"));
        ItemStack aBullet = ST.load(UT.NBT.getNBT(aStack), "gt.ammo");
        if (ST.valid(aBullet)) {
            aList.add(LH.Chat.YELLOW + aBullet.func_82833_r() + LH.Chat._WHITE + aBullet.field_77994_a);
        }
        return aList;
    }

    public boolean isProjectile(ItemStack aStack) {
        return ST.item(aStack) instanceof IItemProjectile && ((IItemProjectile)ST.item(aStack)).hasProjectile(this.mBulletType, aStack);
    }

    public boolean reloadGun(ItemStack aGun, EntityPlayer aPlayer, boolean aOnlyCheckHeld) {
        int i;
        NBTTagCompound aNBT = UT.NBT.getOrCreate(aGun);
        ItemStack aBullet = ST.load(aNBT, "gt.ammo");
        if (ST.valid(aBullet) && aBullet.field_77994_a > 0) {
            return false;
        }
        if (this.isProjectile(aPlayer.field_71071_by.field_70462_a[aPlayer.field_71071_by.field_70461_c])) {
            int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.field_71071_by.field_70462_a[aPlayer.field_71071_by.field_70461_c].field_77994_a);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.field_71071_by.field_70462_a[aPlayer.field_71071_by.field_70461_c]));
            aPlayer.field_71071_by.func_70298_a(aPlayer.field_71071_by.field_70461_c, tConsumed);
            ST.update((Entity)aPlayer);
            return true;
        }
        if (aOnlyCheckHeld) {
            return false;
        }
        for (i = 0; i < aPlayer.field_71071_by.field_70462_a.length; ++i) {
            if (aPlayer.field_71071_by.field_70462_a[i] != aGun) continue;
            if (i >= 27 || !this.isProjectile(aPlayer.field_71071_by.field_70462_a[i + 27])) break;
            if (i < 18 && this.isProjectile(aPlayer.field_71071_by.field_70462_a[i + 18])) {
                if (i < 9 && this.isProjectile(aPlayer.field_71071_by.field_70462_a[i + 9])) {
                    int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.field_71071_by.field_70462_a[i + 9].field_77994_a);
                    UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
                    ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.field_71071_by.field_70462_a[i + 9]));
                    aPlayer.field_71071_by.func_70298_a(i + 9, tConsumed);
                    ST.update((Entity)aPlayer);
                    return true;
                }
                int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.field_71071_by.field_70462_a[i + 18].field_77994_a);
                UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
                ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.field_71071_by.field_70462_a[i + 18]));
                aPlayer.field_71071_by.func_70298_a(i + 18, tConsumed);
                ST.update((Entity)aPlayer);
                return true;
            }
            int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.field_71071_by.field_70462_a[i + 27].field_77994_a);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.field_71071_by.field_70462_a[i + 27]));
            aPlayer.field_71071_by.func_70298_a(i + 27, tConsumed);
            ST.update((Entity)aPlayer);
            return true;
        }
        for (i = aPlayer.field_71071_by.field_70462_a.length - 1; i >= 0; --i) {
            if (!this.isProjectile(aPlayer.field_71071_by.field_70462_a[i])) continue;
            int tConsumed = Math.min(this.mAmmoPerMag, aPlayer.field_71071_by.field_70462_a[i].field_77994_a);
            UT.Sounds.send("random.click", 16.0f, (Entity)aPlayer);
            ST.save(aNBT, "gt.ammo", ST.amount(tConsumed, aPlayer.field_71071_by.field_70462_a[i]));
            aPlayer.field_71071_by.func_70298_a(i, tConsumed);
            ST.update((Entity)aPlayer);
            return true;
        }
        return false;
    }
}

