/*
 * Decompiled with CFR 0.152.
 */
package gregtech.experiments;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.util.WD;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockRiverAdvanced
extends BlockWaterlike {
    public BlockRiverAdvanced(String aName, Fluid aFluid) {
        super(aName, aFluid, false, false);
        this.tickRate = 1;
    }

    public void func_149726_b(World aWorld, int aX, int aY, int aZ) {
        aWorld.func_147464_a(aX, aY, aZ, (Block)this, this.tickRate);
    }

    public void func_149674_a(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        Block tBlock;
        Block[] aBlocks = new Block[7];
        byte[] aMetas = new byte[7];
        byte aMeta = WD.meta(aWorld, aX, aY, aZ, true);
        byte aSource = 6;
        byte aFlow = CS.META_TO_SIDE_1[aMeta];
        for (byte tSide : CS.ALL_SIDES_VALID) {
            aMetas[tSide] = WD.meta(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], true);
            aBlocks[tSide] = WD.block(aWorld, aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide], true);
            if (aBlocks[tSide] == this && aMetas[tSide] - 1 == CS.OPOS[tSide]) {
                aSource = tSide;
            }
            if (aBlocks[tSide] != Blocks.field_150357_h) continue;
            aSource = tSide;
        }
        if (aBlocks[aFlow] != this) {
            aFlow = 6;
        }
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (aBlocks[tSide] != CS.BlocksGT.Ocean && aBlocks[tSide] != CS.BlocksGT.River && aBlocks[tSide] != CS.BlocksGT.Swamp) continue;
            if (CS.SIDES_INVALID[aSource]) {
                WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, 3L);
            }
            return;
        }
        if (CS.SIDES_INVALID[aSource]) {
            WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, 3L);
            return;
        }
        if (aY <= 0) {
            return;
        }
        if (CS.SIDES_BOTTOM[aFlow] && CS.SIDES_HORIZONTAL[aSource] && ((tBlock = WD.block((IBlockAccess)aWorld, aX + CS.OFFX[aSource], aY - 1, aZ + CS.OFFZ[aSource])) == Blocks.field_150346_d || tBlock == Blocks.field_150349_c || tBlock == Blocks.field_150391_bh || tBlock == Blocks.field_150354_m || tBlock == Blocks.field_150351_n || tBlock == Blocks.field_150433_aE)) {
            WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, 3L, true);
            if (aBlocks[aSource] == this) {
                WD.set(aWorld, aX + CS.OFFX[aSource], aY, aZ + CS.OFFZ[aSource], (Block)this, 1 + aFlow, 3L, true);
            }
            WD.set(aWorld, aX + CS.OFFX[aSource], aY - 1, aZ + CS.OFFZ[aSource], (Block)this, 1 + CS.OPOS[aSource], 3L, true);
            return;
        }
        if (aBlocks[0] != this && this.goThisWay(aWorld, aX, aY, aZ, (byte)0)) {
            return;
        }
        if (CS.SIDES_HORIZONTAL[aSource] && CS.SIDES_HORIZONTAL[aFlow] && aBlocks[aSource] == this && !CS.ALONG_AXIS[aFlow][aSource] && aMetas[aFlow] == aMeta && this.goThisWay(aWorld, aX + CS.OFFX[aSource], aY, aZ + CS.OFFZ[aSource], aFlow)) {
            WD.set(aWorld, aX, aY, aZ, CS.NB, 0L, 3L, true);
            WD.set(aWorld, aX + CS.OFFX[aSource] + CS.OFFX[aFlow], aY, aZ + CS.OFFZ[aSource] + CS.OFFZ[aFlow], (Block)this, aMetas[aSource], 3L, true);
            return;
        }
        if (CS.SIDES_VALID[aFlow]) {
            return;
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[aY % CS.ALL_SIDES_HORIZONTAL_ORDER.length]) {
            if (aBlocks[tSide] == this || !this.canDisplace((IBlockAccess)aWorld, aX + CS.OFFX[tSide], aY - 1, aZ + CS.OFFZ[tSide]) || !this.goThisWay(aWorld, aX, aY, aZ, tSide)) continue;
            return;
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[aY % CS.ALL_SIDES_HORIZONTAL_ORDER.length]) {
            if (aBlocks[tSide] == this || !this.canDisplace((IBlockAccess)aWorld, aX + CS.OFFX[tSide] * 2, aY - 1, aZ + CS.OFFZ[tSide] * 2) || !this.goThisWay(aWorld, aX, aY, aZ, tSide)) continue;
            return;
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
            byte tDir;
            if (aBlocks[tSide] != this || aMetas[tSide] == 0 || aMetas[tSide] > 6 || aBlocks[tDir = (byte)(aMetas[tSide] - 1)] == this || !this.goThisWay(aWorld, aX, aY, aZ, tDir)) continue;
            return;
        }
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_ORDER[aY % CS.ALL_SIDES_HORIZONTAL_ORDER.length]) {
            if (aBlocks[tSide] == this || !this.goThisWay(aWorld, aX, aY, aZ, tSide)) continue;
            return;
        }
        WD.set(aWorld, aX, aY, aZ, Blocks.field_150355_j, 0L, 3L, true);
    }

    public boolean goThisWay(World aWorld, int aX, int aY, int aZ, byte aSide) {
        return this.displaceIfPossible(aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide]) && WD.set(aWorld, aX + CS.OFFX[aSide], aY + CS.OFFY[aSide], aZ + CS.OFFZ[aSide], (Block)this, 0L, 3L, true) && WD.set(aWorld, aX, aY, aZ, (Block)this, aSide + 1, 3L, true);
    }

    @Override
    public boolean canDisplace(IBlockAccess aWorld, int aX, int aY, int aZ) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == this) {
            return false;
        }
        if (WD.water(aBlock)) {
            return aWorld.func_72805_g(aX, aY, aZ) > 0;
        }
        if (aBlock.isAir(aWorld, aX, aY, aZ)) {
            return true;
        }
        if (this.displacements.containsKey(aBlock)) {
            return (Boolean)this.displacements.get(aBlock);
        }
        Material aMaterial = aBlock.func_149688_o();
        return !aMaterial.func_76230_c() && !aMaterial.func_76224_d() && aMaterial != Material.field_151567_E;
    }

    @Override
    public boolean displaceIfPossible(World aWorld, int aX, int aY, int aZ) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == this) {
            return false;
        }
        if (WD.water(aBlock)) {
            return aWorld.func_72805_g(aX, aY, aZ) > 0;
        }
        if (aBlock.isAir((IBlockAccess)aWorld, aX, aY, aZ)) {
            return true;
        }
        if (this.displacements.containsKey(aBlock)) {
            if (((Boolean)this.displacements.get(aBlock)).booleanValue()) {
                aBlock.func_149697_b(aWorld, aX, aY, aZ, aWorld.func_72805_g(aX, aY, aZ), 0);
                return true;
            }
            return false;
        }
        Material aMaterial = aBlock.func_149688_o();
        if (aMaterial.func_76230_c() || aMaterial.func_76224_d() || aMaterial == Material.field_151567_E) {
            return false;
        }
        aBlock.func_149697_b(aWorld, aX, aY, aZ, aWorld.func_72805_g(aX, aY, aZ), 0);
        return true;
    }

    @Override
    public int getQuantaValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.quantaPerBlock;
    }

    @Override
    public FluidStack drain(World aWorld, int aX, int aY, int aZ, boolean aDoDrain) {
        return FL.Water.make(1000L);
    }
}

