/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.transformers;

import gregtech.asm.GT_ASM;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.IntHashMap;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;

public class Thaumcraft_AspectLagFix
implements IClassTransformer {
    private static HashMap<Item, IntHashMap> cacheItemHash = new HashMap();
    private static HashMap<Item, IntHashMap> cacheAspectTags = new HashMap();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals("thaumcraft.common.lib.research.ScanManager")) {
            ClassNode classNode = GT_ASM.makeNodes(basicClass);
            for (MethodNode m : classNode.methods) {
                if (!m.name.equals("generateItemHash")) continue;
                GT_ASM.logger.info("Transforming thaumcraft.common.lib.research.ScanManager.generateItemHash");
                LabelNode first = (LabelNode)m.instructions.get(0);
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(21, 1));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new MethodInsnNode(184, "gregtech/asm/transformers/Thaumcraft_AspectLagFix", "getCachedItemHash", "(Lnet/minecraft/item/Item;I)I", false));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(89));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new JumpInsnNode(153, first));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(172));
                m.instructions.insert((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(87));
                for (AbstractInsnNode node = first.getNext(); node != null; node = node.getNext()) {
                    InsnNode ret;
                    if (!(node instanceof InsnNode) || (ret = (InsnNode)node).getOpcode() != 172) continue;
                    m.instructions.insertBefore((AbstractInsnNode)ret, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore((AbstractInsnNode)ret, (AbstractInsnNode)new VarInsnNode(21, 1));
                    m.instructions.insertBefore((AbstractInsnNode)ret, (AbstractInsnNode)new MethodInsnNode(184, "gregtech/asm/transformers/Thaumcraft_AspectLagFix", "setCachedItemHash", "(ILnet/minecraft/item/Item;I)I", false));
                }
            }
            return GT_ASM.writeByteArray(classNode);
        }
        if (name.equals("thaumcraft.common.lib.crafting.ThaumcraftCraftingManager")) {
            ClassNode classNode = GT_ASM.makeNodes(basicClass);
            for (MethodNode m : classNode.methods) {
                if (!m.name.equals("getObjectTags")) continue;
                GT_ASM.logger.info("Transforming thaumcraft.common.lib.crafting.ThaumcraftCraftingManager.getObjectTags");
                LabelNode first = (LabelNode)m.instructions.get(0);
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new VarInsnNode(25, 0));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new MethodInsnNode(184, "gregtech/asm/transformers/Thaumcraft_AspectLagFix", "getCachedAspectTags", "(Lnet/minecraft/item/ItemStack;)Lthaumcraft/api/aspects/AspectList;", false));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(89));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new JumpInsnNode(198, first));
                m.instructions.insertBefore((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(176));
                m.instructions.insert((AbstractInsnNode)first, (AbstractInsnNode)new InsnNode(87));
                for (AbstractInsnNode node = first.getNext(); node != null; node = node.getNext()) {
                    InsnNode ret;
                    if (!(node instanceof InsnNode) || (ret = (InsnNode)node).getOpcode() != 176) continue;
                    m.instructions.insertBefore((AbstractInsnNode)ret, (AbstractInsnNode)new VarInsnNode(25, 0));
                    m.instructions.insertBefore((AbstractInsnNode)ret, (AbstractInsnNode)new MethodInsnNode(184, "gregtech/asm/transformers/Thaumcraft_AspectLagFix", "setCachedAspectTags", "(Lthaumcraft/api/aspects/AspectList;Lnet/minecraft/item/ItemStack;)Lthaumcraft/api/aspects/AspectList;", false));
                }
            }
            return GT_ASM.writeByteArray(classNode);
        }
        return basicClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCachedItemHash(Item item, int meta) {
        if (item == null) {
            return -1;
        }
        HashMap<Item, IntHashMap> hashMap = cacheItemHash;
        synchronized (hashMap) {
            IntHashMap metaMap = cacheItemHash.get(item);
            if (metaMap != null) {
                Integer hash = (Integer)metaMap.func_76041_a(meta);
                if (hash != null) {
                    return hash;
                }
                hash = (Integer)metaMap.func_76041_a(-1);
                if (hash != null) {
                    return hash;
                }
                int[] grouped = (int[])ThaumcraftApi.groupedObjectTags.get(Arrays.asList(item, meta));
                if (grouped != null && (hash = (Integer)metaMap.func_76041_a(grouped[0])) != null) {
                    return hash;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setCachedItemHash(int hash, Item item, int meta) {
        HashMap<Item, IntHashMap> hashMap = cacheItemHash;
        synchronized (hashMap) {
            IntHashMap metaMap = cacheItemHash.get(item);
            if (metaMap == null) {
                metaMap = new IntHashMap();
                cacheItemHash.put(item, metaMap);
            }
            metaMap.func_76038_a(meta, (Object)hash);
            return hash;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AspectList getCachedAspectTags(ItemStack is) {
        if (is == null || is.func_77973_b() == null) {
            return null;
        }
        HashMap<Item, IntHashMap> hashMap = cacheAspectTags;
        synchronized (hashMap) {
            AspectList aspects;
            IntHashMap metaMap = cacheAspectTags.get(is.func_77973_b());
            if (metaMap != null && (aspects = (AspectList)metaMap.func_76041_a(is.func_77960_j())) != null) {
                return aspects.copy();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AspectList setCachedAspectTags(AspectList aspects, ItemStack is) {
        HashMap<Item, IntHashMap> hashMap = cacheAspectTags;
        synchronized (hashMap) {
            if (aspects == null || is == null || is.func_77973_b() == null) {
                return null;
            }
            IntHashMap metaMap = cacheAspectTags.get(is.func_77973_b());
            if (metaMap == null) {
                metaMap = new IntHashMap();
                cacheAspectTags.put(is.func_77973_b(), metaMap);
            }
            metaMap.func_76038_a(is.func_77960_j(), (Object)aspects.copy());
            return aspects;
        }
    }
}

