/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.transformers;

import gregtech.asm.GT_ASM;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;

public class Minecraft_MinecraftServerIntegratedLaunchMainMenuPartialFix
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.server.MinecraftServer")) {
            return basicClass;
        }
        ClassNode classNode = GT_ASM.makeNodes(basicClass);
        for (MethodNode m : classNode.methods) {
            AbstractInsnNode node;
            if (!m.name.equals("run")) continue;
            GT_ASM.logger.info("Transforming net.minecraft.server.MinecraftServer.run");
            for (node = m.instructions.getFirst(); node != null && (!(node instanceof LineNumberNode) || ((LineNumberNode)node).line != 391 && ((LineNumberNode)node).line != 449); node = node.getNext()) {
            }
            if (node == null) {
                GT_ASM.logger.info("net.minecraft.server.MinecraftServer.run appears to be corrupt!  Ignoring and not touching!");
                return basicClass;
            }
            AbstractInsnNode constNode = node.getNext();
            if (!(constNode instanceof InsnNode) || ((InsnNode)constNode).getOpcode() != 9) {
                GT_ASM.logger.warn("Node is apparently already altered?");
                return basicClass;
            }
            m.instructions.remove(constNode);
            m.instructions.insert(node, (AbstractInsnNode)new LdcInsnNode((Object)new Long(2001L)));
        }
        ClassWriter writer = new ClassWriter(3){

            protected String getCommonSuperClass(String type1, String type2) {
                Class<?> d;
                Class<?> c;
                ClassLoader classLoader = GT_ASM.classLoader;
                try {
                    c = Class.forName(type1.replace('/', '.'), false, classLoader);
                    d = Class.forName(type2.replace('/', '.'), false, classLoader);
                }
                catch (Exception e) {
                    return "java/lang/Object";
                }
                if (c.isAssignableFrom(d)) {
                    return type1;
                }
                if (d.isAssignableFrom(c)) {
                    return type2;
                }
                if (c.isInterface() || d.isInterface()) {
                    return "java/lang/Object";
                }
                while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                }
                return c.getName().replace('.', '/');
            }
        };
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

