/*
 * Decompiled with CFR 0.152.
 */
package gregapi.wooddict;

import gregapi.data.MT;
import gregapi.oredict.OreDictMaterial;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.wooddict.LeafEntry;
import gregapi.wooddict.WoodDictionary;
import gregapi.wooddict.WoodEntry;
import net.minecraft.item.ItemStack;

public class SaplingEntry {
    public ItemStack mSapling;
    public WoodEntry mWoodEntry;
    public LeafEntry mLeafEntry;
    public OreDictMaterial mMaterialSapling = MT.Wood;
    public boolean mBaggedSaplingLoot = false;
    public int mCount = 1;

    public SaplingEntry(ItemStack aSapling, WoodEntry aWood) {
        if (ST.invalid(aSapling)) {
            return;
        }
        this.mSapling = ST.amount(1L, aSapling);
        this.mCount = UT.Code.bindStack(ST.size(aSapling));
        this.mWoodEntry = aWood;
        if (this.mWoodEntry != null) {
            this.mWoodEntry.mSaplingEntries.add(this);
            this.mMaterialSapling = this.mWoodEntry.mMaterialWood;
        }
        WoodDictionary.SAPLINGS.put(this.mSapling, this);
        WoodDictionary.LIST_SAPLINGS.add(this);
    }

    public SaplingEntry(ItemStack aSapling, WoodEntry aWood, ItemStack aLeaf) {
        if (ST.invalid(aSapling) || ST.invalid(aLeaf)) {
            return;
        }
        this.mSapling = ST.amount(1L, aSapling);
        this.mCount = UT.Code.bindStack(ST.size(aSapling));
        this.mLeafEntry = new LeafEntry(aLeaf);
        this.mLeafEntry.mSaplingEntries.add(this);
        this.mWoodEntry = aWood;
        if (this.mWoodEntry != null) {
            this.mWoodEntry.mSaplingEntries.add(this);
            this.mMaterialSapling = this.mWoodEntry.mMaterialWood;
        }
        WoodDictionary.SAPLINGS.put(this.mSapling, this);
        WoodDictionary.LIST_SAPLINGS.add(this);
    }

    public SaplingEntry(ItemStack aSapling, WoodEntry aWood, LeafEntry aLeaf) {
        if (ST.invalid(aSapling)) {
            return;
        }
        this.mSapling = ST.amount(1L, aSapling);
        this.mCount = UT.Code.bindStack(ST.size(aSapling));
        this.mLeafEntry = aLeaf;
        this.mLeafEntry.mSaplingEntries.add(this);
        this.mWoodEntry = aWood;
        if (this.mWoodEntry != null) {
            this.mWoodEntry.mSaplingEntries.add(this);
            this.mMaterialSapling = this.mWoodEntry.mMaterialWood;
        }
        WoodDictionary.SAPLINGS.put(this.mSapling, this);
        WoodDictionary.LIST_SAPLINGS.add(this);
    }
}

