/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.inventories;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OD;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.dummies.DummyInventory;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.network.packets.PacketItemStackChat;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.inventories.ITileEntityBookShelf;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityBookShelf
extends TileEntityBase09FacingSingle
implements ITileEntityBookShelf,
IMultiTileEntity.IMTE_GetEnchantPowerBonus,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState {
    public byte[] mDisplay = new byte[28];
    public byte mRedstoneDelay = 0;
    public IIconContainer mShelfIcon = Textures.BlockIcons.RENDERING_ERROR;
    public String mDungeonLootNameFront = "";
    public String mDungeonLootNameBack = "";

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        short tShelfID;
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.dungeonloot.front")) {
            this.mDungeonLootNameFront = aNBT.func_74779_i("gt.dungeonloot.front");
        }
        if (aNBT.func_74764_b("gt.dungeonloot.back")) {
            this.mDungeonLootNameBack = aNBT.func_74779_i("gt.dungeonloot.back");
        }
        if (aNBT.func_74764_b("gt.redstone")) {
            this.mRedstoneDelay = aNBT.func_74771_c("gt.redstone");
        }
        if (aNBT.func_74764_b("gt.texture") && UT.Code.exists(tShelfID = aNBT.func_74765_d("gt.texture"), CS.PlankData.PLANK_ICONS)) {
            this.mShelfIcon = CS.PlankData.PLANK_ICONS[tShelfID];
        }
        if (this.mShelfIcon == null || this.mShelfIcon == Textures.BlockIcons.RENDERING_ERROR) {
            this.mShelfIcon = this.mMaterial.mTextureSetsBlock.get(OP.casingMachine.mIconIndexBlock);
        }
        for (int i = 0; i < this.mDisplay.length; ++i) {
            Byte tID;
            Byte by = tID = this.slotHas(i) ? (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(this.slot(i))) : null;
            if ((tID == null || tID == 0) && this.slotHas(i)) {
                tID = (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(this.slot(i), 32767L));
            }
            this.mDisplay[i] = tID == null ? (byte)0 : tID;
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (UT.Code.stringValid(this.mDungeonLootNameFront)) {
            aNBT.func_74778_a("gt.dungeonloot.front", this.mDungeonLootNameFront);
        }
        if (UT.Code.stringValid(this.mDungeonLootNameBack)) {
            aNBT.func_74778_a("gt.dungeonloot.back", this.mDungeonLootNameBack);
        }
        if (this.mRedstoneDelay != 0) {
            aNBT.func_74774_a("gt.redstone", this.mRedstoneDelay);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean breakBlock() {
        this.generateDungeonLoot();
        return super.breakBlock();
    }

    protected void generateDungeonLoot() {
        if (this.isServerSide()) {
            int tSlot;
            DummyInventory tDummyInventory;
            if (UT.Code.stringValid(this.mDungeonLootNameFront) && ST.generateLoot(CS.RNGSUS, this.mDungeonLootNameFront, tDummyInventory = new DummyInventory(14))) {
                for (ItemStack tStack : tDummyInventory.mInventory) {
                    tSlot = this.rng(14);
                    if (this.slotHas(tSlot)) continue;
                    if (CS.BooksGT.BOOK_REGISTER.containsKey(tStack, true)) {
                        this.slot(tSlot, ST.amount(1L, tStack));
                        continue;
                    }
                    this.slot(tSlot, this.rng(4) != 0 ? ST.make(Items.field_151122_aG, 1L, 0L) : ST.make(MD.LOSTBOOKS, "randomBook", 1L, 0L, Items.field_151122_aG));
                }
                this.mDungeonLootNameFront = "";
                this.updateInventory();
            }
            if (UT.Code.stringValid(this.mDungeonLootNameBack) && ST.generateLoot(CS.RNGSUS, this.mDungeonLootNameBack, tDummyInventory = new DummyInventory(14))) {
                for (ItemStack tStack : tDummyInventory.mInventory) {
                    tSlot = 14 + this.rng(14);
                    if (this.slotHas(tSlot)) continue;
                    if (CS.BooksGT.BOOK_REGISTER.containsKey(tStack, true)) {
                        this.slot(tSlot, ST.amount(1L, tStack));
                        continue;
                    }
                    this.slot(tSlot, this.rng(4) != 0 ? ST.make(Items.field_151122_aG, 1L, 0L) : ST.make(MD.LOSTBOOKS, "randomBook", 1L, 0L, Items.field_151122_aG));
                }
                this.mDungeonLootNameBack = "";
                this.updateInventory();
            }
        }
    }

    @Override
    public float getEnchantPowerBonus() {
        float tPoints = 0.0f;
        for (int i = 0; i < this.mDisplay.length; ++i) {
            if (!this.slotHas(i)) continue;
            if (CS.BooksGT.BOOKS_ENCHANTED.contains(this.slot(i), true)) {
                tPoints += 2.0f;
                continue;
            }
            if (!CS.BooksGT.BOOKS_NORMAL.contains(this.slot(i), true)) continue;
            tPoints += 1.0f;
        }
        return (float)(this.mMaterial.contains(TD.Properties.MAGICAL) ? 1 : 0) + tPoints / 12.0f;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (aTimer % 300L == 0L && (UT.Code.stringValid(this.mDungeonLootNameFront) || UT.Code.stringValid(this.mDungeonLootNameBack)) && !this.field_145850_b.func_72872_a(EntityPlayer.class, this.box(-32.0, -32.0, -32.0, 33.0, 33.0, 33.0)).isEmpty()) {
                this.generateDungeonLoot();
            }
            if (this.mRedstoneDelay > 0 && (this.mRedstoneDelay = (byte)(this.mRedstoneDelay - 1)) == 0) {
                this.causeBlockUpdate();
            }
            if (this.mInventoryChanged) {
                for (int i = 0; i < this.mDisplay.length; ++i) {
                    Byte tID;
                    Byte by = tID = this.slotHas(i) ? (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(this.slot(i))) : null;
                    if ((tID == null || tID == 0) && this.slotHas(i)) {
                        tID = (Byte)CS.BooksGT.BOOK_REGISTER.get(new ItemStackContainer(this.slot(i), 32767L));
                    }
                    if (tID == null) {
                        tID = 0;
                    }
                    if (tID == this.mDisplay[i]) continue;
                    this.mDisplay[i] = tID;
                    this.updateClientData();
                }
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("magnifyingglass") && aPlayer instanceof EntityPlayerMP && (tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] >= CS.PX_P[1] && tCoords[0] <= CS.PX_N[1] && tCoords[1] >= CS.PX_P[1] && tCoords[1] <= CS.PX_N[1]) {
            int tIndex = -1;
            if (aSide == this.mFacing) {
                tIndex = (tCoords[1] < CS.PX_P[8] ? 6 : 13) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PX_P[1])));
            }
            if (aSide == CS.OPOS[this.mFacing]) {
                tIndex = (tCoords[1] < CS.PX_P[8] ? 20 : 27) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PX_P[1])));
            }
            if (tIndex >= 0 && this.slotHas(tIndex)) {
                CS.NW_API.sendToPlayer(new PacketItemStackChat(this.slot(tIndex)), (EntityPlayerMP)aPlayer);
                return 1L;
            }
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        if (this.isServerSide() && this.isUseableByPlayerGUI(aPlayer)) {
            this.generateDungeonLoot();
        }
        if ((tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] >= CS.PX_P[1] && tCoords[0] <= CS.PX_N[1] && tCoords[1] >= CS.PX_P[1] && tCoords[1] <= CS.PX_N[1]) {
            if (aSide == this.mFacing) {
                if (this.isServerSide()) {
                    this.switchBooks(aPlayer, (tCoords[1] < CS.PX_P[8] ? 6 : 13) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PX_P[1]))));
                }
                return true;
            }
            if (aSide == CS.OPOS[this.mFacing]) {
                if (this.isServerSide()) {
                    this.switchBooks(aPlayer, (tCoords[1] < CS.PX_P[8] ? 20 : 27) - (int)UT.Code.bind_(0L, 6L, (long)(8.0f * (tCoords[0] - CS.PX_P[1]))));
                }
                return true;
            }
        }
        return false;
    }

    private boolean switchBooks(EntityPlayer aPlayer, int aSlot) {
        if (this.slotHas(aSlot)) {
            if (!aPlayer.func_70093_af()) {
                if (OD.button.is(this.slot(aSlot))) {
                    this.mRedstoneDelay = (byte)120;
                    this.causeBlockUpdate();
                    this.playClick();
                    return true;
                }
                if (OD.lever.is(this.slot(aSlot)) || ST.equal(this.slot(aSlot), Blocks.field_150429_aA)) {
                    this.mRedstoneDelay = this.mRedstoneDelay == 0 ? (byte)-1 : (byte)0;
                    this.causeBlockUpdate();
                    this.playClick();
                    return true;
                }
            }
            if (ST.add((Entity)aPlayer, this.slot(aSlot), true)) {
                this.slotKill(aSlot);
                this.updateInventory();
                this.playCollect();
                return true;
            }
            return false;
        }
        ItemStack tStack = aPlayer.func_71045_bC();
        if (ST.valid(tStack) && CS.BooksGT.BOOK_REGISTER.containsKey(tStack, true)) {
            this.slot(aSlot, ST.amount(1L, tStack));
            --tStack.field_77994_a;
            this.updateInventory();
            this.playCollect();
            return true;
        }
        return false;
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return (byte)(this.mRedstoneDelay == 0 ? 0 : 15);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), this.mDisplay[0], this.mDisplay[1], this.mDisplay[2], this.mDisplay[3], this.mDisplay[4], this.mDisplay[5], this.mDisplay[6], this.mDisplay[7], this.mDisplay[8], this.mDisplay[9], this.mDisplay[10], this.mDisplay[11], this.mDisplay[12], this.mDisplay[13], this.mDisplay[14], this.mDisplay[15], this.mDisplay[16], this.mDisplay[17], this.mDisplay[18], this.mDisplay[19], this.mDisplay[20], this.mDisplay[21], this.mDisplay[22], this.mDisplay[23], this.mDisplay[24], this.mDisplay[25], this.mDisplay[26], this.mDisplay[27]);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        for (int i = 0; i < this.mDisplay.length; ++i) {
            this.mDisplay[i] = aData[i + 4];
        }
        return true;
    }

    @Override
    public boolean isCoverSurface(byte aSide, int aRenderpass) {
        return aRenderpass == 0 && super.isCoverSurface(aSide);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 35;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return aRenderPass < 7 || this.mDisplay[aRenderPass - 7] != 0 && aShouldSideBeRendered[aRenderPass < 21 ? this.mFacing : CS.OPOS[this.mFacing]];
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return false;
            }
            case 1: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[15], CS.PX_N[0]);
            }
            case 2: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[15], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            }
            case 3: {
                return this.box(aBlock, CS.PX_P[0], CS.PX_P[1], CS.PX_P[0], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 15 : 0], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 0]);
            }
            case 4: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 15 : 0], CS.PX_P[1], CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 15 : 0], CS.PX_N[0], CS.PX_N[1], CS.PX_N[0]);
            }
            case 5: {
                return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_P[1], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 7 : 1], CS.PX_N[1], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 7 : 1]);
            }
            case 6: {
                return this.box(aBlock, CS.PX_P[1], CS.PX_P[7], CS.PX_P[1], CS.PX_N[1], CS.PX_N[7], CS.PX_N[1]);
            }
        }
        aRenderPass -= 7;
        switch (this.mFacing) {
            case 5: {
                if (aRenderPass < 7) {
                    return this.box(aBlock, CS.PX_P[9], CS.PX_P[9], CS.PX_N[15 - aRenderPass * 2], CS.PX_N[2], CS.PX_N[1], CS.PX_N[13 - aRenderPass * 2]);
                }
                if (aRenderPass < 14) {
                    return this.box(aBlock, CS.PX_P[9], CS.PX_P[1], CS.PX_N[15 - (aRenderPass %= 7) * 2], CS.PX_N[2], CS.PX_N[9], CS.PX_N[13 - aRenderPass * 2]);
                }
                if (aRenderPass < 21) {
                    return this.box(aBlock, CS.PX_P[2], CS.PX_P[9], CS.PX_N[3 + (aRenderPass %= 7) * 2], CS.PX_N[9], CS.PX_N[1], CS.PX_N[1 + aRenderPass * 2]);
                }
                return this.box(aBlock, CS.PX_P[2], CS.PX_P[1], CS.PX_N[3 + (aRenderPass %= 7) * 2], CS.PX_N[9], CS.PX_N[9], CS.PX_N[1 + aRenderPass * 2]);
            }
            case 4: {
                if (aRenderPass < 7) {
                    return this.box(aBlock, CS.PX_P[2], CS.PX_P[9], CS.PX_P[13 - aRenderPass * 2], CS.PX_N[9], CS.PX_N[1], CS.PX_P[15 - aRenderPass * 2]);
                }
                if (aRenderPass < 14) {
                    return this.box(aBlock, CS.PX_P[2], CS.PX_P[1], CS.PX_P[13 - (aRenderPass %= 7) * 2], CS.PX_N[9], CS.PX_N[9], CS.PX_P[15 - aRenderPass * 2]);
                }
                if (aRenderPass < 21) {
                    return this.box(aBlock, CS.PX_P[9], CS.PX_P[9], CS.PX_P[1 + (aRenderPass %= 7) * 2], CS.PX_N[2], CS.PX_N[1], CS.PX_P[3 + aRenderPass * 2]);
                }
                return this.box(aBlock, CS.PX_P[9], CS.PX_P[1], CS.PX_P[1 + (aRenderPass %= 7) * 2], CS.PX_N[2], CS.PX_N[9], CS.PX_P[3 + aRenderPass * 2]);
            }
            case 3: {
                if (aRenderPass < 7) {
                    return this.box(aBlock, CS.PX_N[3 + aRenderPass * 2], CS.PX_P[9], CS.PX_P[9], CS.PX_N[1 + aRenderPass * 2], CS.PX_N[1], CS.PX_N[2]);
                }
                if (aRenderPass < 14) {
                    return this.box(aBlock, CS.PX_N[3 + (aRenderPass %= 7) * 2], CS.PX_P[1], CS.PX_P[9], CS.PX_N[1 + aRenderPass * 2], CS.PX_N[9], CS.PX_N[2]);
                }
                if (aRenderPass < 21) {
                    return this.box(aBlock, CS.PX_N[15 - (aRenderPass %= 7) * 2], CS.PX_P[9], CS.PX_P[2], CS.PX_N[13 - aRenderPass * 2], CS.PX_N[1], CS.PX_N[9]);
                }
                return this.box(aBlock, CS.PX_N[15 - (aRenderPass %= 7) * 2], CS.PX_P[1], CS.PX_P[2], CS.PX_N[13 - aRenderPass * 2], CS.PX_N[9], CS.PX_N[9]);
            }
            case 2: {
                if (aRenderPass < 7) {
                    return this.box(aBlock, CS.PX_P[1 + aRenderPass * 2], CS.PX_P[9], CS.PX_P[2], CS.PX_P[3 + aRenderPass * 2], CS.PX_N[1], CS.PX_N[9]);
                }
                if (aRenderPass < 14) {
                    return this.box(aBlock, CS.PX_P[1 + (aRenderPass %= 7) * 2], CS.PX_P[1], CS.PX_P[2], CS.PX_P[3 + aRenderPass * 2], CS.PX_N[9], CS.PX_N[9]);
                }
                if (aRenderPass < 21) {
                    return this.box(aBlock, CS.PX_P[13 - (aRenderPass %= 7) * 2], CS.PX_P[9], CS.PX_P[9], CS.PX_P[15 - aRenderPass * 2], CS.PX_N[1], CS.PX_N[2]);
                }
                return this.box(aBlock, CS.PX_P[13 - (aRenderPass %= 7) * 2], CS.PX_P[1], CS.PX_P[9], CS.PX_P[15 - aRenderPass * 2], CS.PX_N[9], CS.PX_N[2]);
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass < 7) {
            if (CS.ALONG_AXIS[aSide][this.mFacing] && !aShouldSideBeRendered[aSide]) {
                return null;
            }
            switch (aRenderPass) {
                case 0: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || !aShouldSideBeRendered[aSide] ? null : BlockTextureDefault.get(this.mShelfIcon, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING));
                }
                case 1: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || CS.SIDES_TOP[aSide] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)) : null;
                }
                case 2: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || CS.SIDES_BOTTOM[aSide] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)) : null;
                }
                case 3: {
                    return aSide == (CS.SIDES_AXIS_Z[this.mFacing] ? (byte)4 : 2) ? null : BlockTextureDefault.get(this.mShelfIcon, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING));
                }
                case 4: {
                    return aSide == (CS.SIDES_AXIS_Z[this.mFacing] ? (byte)5 : 3) ? null : BlockTextureDefault.get(this.mShelfIcon, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING));
                }
                case 5: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)) : null;
                }
                case 6: {
                    return CS.ALONG_AXIS[aSide][this.mFacing] || CS.SIDES_VERTICAL[aSide] ? BlockTextureDefault.get(this.mShelfIcon, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)) : null;
                }
            }
        }
        if (CS.SIDES_VERTICAL[aSide] || aSide == (aRenderPass < 21 ? CS.OPOS[this.mFacing] : this.mFacing)) {
            return null;
        }
        return (CS.ALONG_AXIS[aSide][this.mFacing] ? CS.BooksGT.BOOK_TEXTURES_BACK : CS.BooksGT.BOOK_TEXTURES_SIDE)[UT.Code.unsignB(this.mDisplay[aRenderPass - 7])];
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0], 0.0, CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0], 1.0, CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0], 0.0, CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? 2 : 0], 1.0, CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? 2 : 0]);
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return !CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public boolean isShelfFace(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing];
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return 1;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[this.mDisplay.length];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public ItemStack getDefaultStack(int aSlot) {
        return ST.make(Items.field_151122_aG, 1L, 0L);
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return this.slotHas(aSlot) && !ST.equal(this.slot(aSlot), Blocks.field_150347_e) && !ST.equal(this.slot(aSlot), Blocks.field_150429_aA) && !OD.lever.is(this.slot(aSlot)) && !OD.button.is(this.slot(aSlot));
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return !this.slotHas(aSlot) && CS.BooksGT.BOOK_REGISTER.containsKey(aStack, true) && !ST.equal(this.slot(aSlot), Blocks.field_150347_e) && !ST.equal(this.slot(aSlot), Blocks.field_150429_aA) && !OD.lever.is(this.slot(aSlot)) && !OD.button.is(this.slot(aSlot));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.shelf.books";
    }
}

