/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.render.ITexture;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class BlockTextureFluid
implements ITexture {
    private final boolean mAllowAlpha;
    private final int mLuminosity;
    private final IIcon mIcon;
    public short[] mRGBa;

    public static BlockTextureFluid get(IFluidTank aTank, boolean aAllowAlpha) {
        return CS.CODE_CLIENT ? new BlockTextureFluid(aTank.getFluid(), aAllowAlpha) : null;
    }

    public static BlockTextureFluid get(IFluidTank aTank) {
        return CS.CODE_CLIENT ? new BlockTextureFluid(aTank.getFluid()) : null;
    }

    public static BlockTextureFluid get(FluidStack aFluidStack, boolean aAllowAlpha) {
        return CS.CODE_CLIENT ? new BlockTextureFluid(aFluidStack, aAllowAlpha) : null;
    }

    public static BlockTextureFluid get(FluidStack aFluidStack) {
        return CS.CODE_CLIENT ? new BlockTextureFluid(aFluidStack) : null;
    }

    public static BlockTextureFluid get(Fluid aFluid, boolean aAllowAlpha) {
        return CS.CODE_CLIENT ? new BlockTextureFluid(aFluid, aAllowAlpha) : null;
    }

    public static BlockTextureFluid get(Fluid aFluid) {
        return CS.CODE_CLIENT ? new BlockTextureFluid(aFluid) : null;
    }

    public static BlockTextureFluid get(FL aFluid) {
        return CS.CODE_CLIENT ? new BlockTextureFluid(aFluid.fluid()) : null;
    }

    public BlockTextureFluid(FluidStack aFluid, boolean aAllowAlpha) {
        if (aFluid == null || aFluid.getFluid() == null) {
            this.mLuminosity = 0;
            this.mRGBa = CS.UNCOLOURED;
            this.mIcon = null;
        } else {
            this.mLuminosity = aFluid.getFluid().getLuminosity(aFluid) * 16;
            Block tBlock = aFluid.getFluid().getBlock();
            if (tBlock != null && tBlock != CS.NB) {
                this.mIcon = tBlock.func_149691_a(0, 0);
                this.mRGBa = UT.Code.getRGBaArray(tBlock.func_149741_i(0));
            } else {
                this.mIcon = aFluid.getFluid().getStillIcon();
                this.mRGBa = UT.Code.getRGBaArray(aFluid.getFluid().getColor(aFluid));
            }
        }
        this.mAllowAlpha = aAllowAlpha;
    }

    public BlockTextureFluid(FluidStack aFluidStack) {
        this(aFluidStack, false);
    }

    public BlockTextureFluid(Fluid aFluid, boolean aAllowAlpha) {
        this(FL.make(aFluid, 0L), aAllowAlpha);
    }

    public BlockTextureFluid(Fluid aFluid) {
        this(aFluid, false);
    }

    private IIcon getIcon(int aSide) {
        return this.mIcon;
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)5, this.getIcon(5), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)4, this.getIcon(4), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)1, this.getIcon(1), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)0, this.getIcon(0), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)3, this.getIcon(3), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        ITexture.Util.renderSide((byte)2, this.getIcon(2), this.mRGBa, this.mAllowAlpha, this.mLuminosity > aBrightness, true, aRenderer, aBlock, aX, aY, aZ, Math.max(this.mLuminosity, aBrightness), aChangedBlockBounds);
    }

    @Override
    public boolean isValidTexture() {
        return this.mIcon != null;
    }
}

