/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes;

import gregapi.code.TagData;
import gregapi.item.IItemEnergy;
import gregapi.item.IItemGTContainerTool;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.recipes.ICraftingRecipeGT;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AdvancedCraftingShapeless
extends ShapelessOreRecipe
implements ICraftingRecipeGT {
    public final boolean mDismantleable;
    public final boolean mRemovableByGT;
    public final boolean mAutoCraftable;
    public final boolean mKeepingNBT;
    private final Enchantment[] mEnchantmentsAdded;
    private final int[] mEnchantmentLevelsAdded;

    public AdvancedCraftingShapeless(ItemStack aResult, boolean aDismantleAble, boolean aRemovableByGT, boolean aKeepingNBT, boolean aAutoCraftable, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, Object ... aRecipe) {
        super(aResult, aRecipe);
        this.mEnchantmentsAdded = aEnchantmentsAdded;
        this.mEnchantmentLevelsAdded = aEnchantmentLevelsAdded;
        this.mRemovableByGT = aRemovableByGT;
        this.mKeepingNBT = aKeepingNBT;
        this.mDismantleable = aDismantleAble;
        this.mAutoCraftable = aAutoCraftable;
    }

    public boolean func_77569_a(InventoryCrafting aGrid, World aWorld) {
        if (this.mKeepingNBT) {
            ItemStack tStack = null;
            ItemStack tMainInput = this.getInput().get(0) instanceof ItemStack ? (ItemStack)this.getInput().get(0) : null;
            for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                if (aGrid.func_70301_a(i) == null) continue;
                if (tMainInput == null) {
                    if (!(this.getInput().get(0) instanceof Iterable)) continue;
                    for (Object tObject : (Iterable)this.getInput().get(0)) {
                        if (!(tObject instanceof ItemStack) || !ST.equal(aGrid.func_70301_a(i), (ItemStack)tObject, true)) continue;
                        tMainInput = ST.amount(1L, aGrid.func_70301_a(i));
                    }
                    continue;
                }
                if (!ST.equal_(aGrid.func_70301_a(i), tMainInput, true)) continue;
                if (tStack != null && !ST.equal_(tStack, aGrid.func_70301_a(i), false)) {
                    return false;
                }
                tStack = aGrid.func_70301_a(i);
            }
        }
        return super.func_77569_a(aGrid, aWorld);
    }

    public ItemStack func_77572_b(InventoryCrafting aGrid) {
        ItemStack rStack = super.func_77572_b(aGrid);
        if (rStack != null) {
            ST.update(rStack);
            if (this.mKeepingNBT) {
                ItemStack tMainInput = this.getInput().get(0) instanceof ItemStack ? (ItemStack)this.getInput().get(0) : null;
                for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                    if (aGrid.func_70301_a(i) == null || !aGrid.func_70301_a(i).func_77942_o() || tMainInput != null && !ST.equal_(aGrid.func_70301_a(i), tMainInput, true)) continue;
                    UT.NBT.set(rStack, (NBTTagCompound)aGrid.func_70301_a(i).func_77978_p().func_74737_b());
                    break;
                }
            }
            if (rStack.func_77973_b() instanceof IItemEnergy) {
                for (TagData tEnergyType : ((IItemEnergy)rStack.func_77973_b()).getEnergyTypes(rStack)) {
                    long tCharge = 0L;
                    for (int i = 0; i < aGrid.func_70302_i_(); ++i) {
                        if (aGrid.func_70301_a(i) == null || !(aGrid.func_70301_a(i).func_77973_b() instanceof IItemEnergy) || aGrid.func_70301_a(i).func_77973_b() instanceof IItemGTContainerTool) continue;
                        tCharge += ((IItemEnergy)aGrid.func_70301_a(i).func_77973_b()).getEnergyStored(tEnergyType, aGrid.func_70301_a(i));
                    }
                    ((IItemEnergy)rStack.func_77973_b()).setEnergyStored(tEnergyType, rStack, tCharge);
                }
            }
            if (this.mDismantleable) {
                NBTTagCompound rNBT = rStack.func_77978_p();
                NBTTagCompound tNBT = UT.NBT.make();
                if (rNBT == null) {
                    rNBT = UT.NBT.make();
                }
                for (int i = 0; i < 9; ++i) {
                    ItemStack tStack = aGrid.func_70301_a(i);
                    if (tStack == null || ST.container(tStack, true) != null || tStack.func_77973_b() instanceof MultiItemTool) continue;
                    tStack = ST.amount(1L, tStack);
                    tNBT.func_74782_a("" + i, (NBTBase)ST.save(tStack));
                }
                rNBT.func_74782_a("gt.recycling.comps", (NBTBase)tNBT);
                UT.NBT.set(rStack, rNBT);
            }
            for (int i = 0; i < this.mEnchantmentsAdded.length; ++i) {
                UT.NBT.addEnchantment(rStack, this.mEnchantmentsAdded[i], UT.NBT.getEnchantmentLevel(this.mEnchantmentsAdded[i], rStack) + this.mEnchantmentLevelsAdded[i]);
            }
            ST.update(rStack);
        }
        return rStack;
    }

    @Override
    public boolean isRemovableByGT() {
        return this.mRemovableByGT;
    }

    @Override
    public boolean isAutocraftableByGT() {
        return this.mAutoCraftable;
    }
}

