/*
 * Decompiled with CFR 0.152.
 */
package gregapi.oredict;

import gregapi.code.ICondition;
import gregapi.code.TagData;
import gregapi.oredict.OreDictPrefix;

public class OreDictPrefixCondition {
    public static ICondition<OreDictPrefix> tag(TagData ... aTags) {
        return new TagDataContainsAll(aTags);
    }

    public static ICondition<OreDictPrefix> tagnor(TagData ... aTags) {
        return new TagDataContainsNone(aTags);
    }

    private static class TagDataContainsNone
    implements ICondition<OreDictPrefix> {
        private final TagData[] mTags;

        public TagDataContainsNone(TagData ... aTags) {
            this.mTags = aTags;
        }

        @Override
        public boolean isTrue(OreDictPrefix aPrefix) {
            for (TagData tTag : this.mTags) {
                if (!aPrefix.contains(tTag)) continue;
                return false;
            }
            return true;
        }
    }

    private static class TagDataContainsAll
    implements ICondition<OreDictPrefix> {
        private final TagData[] mTags;

        public TagDataContainsAll(TagData ... aTags) {
            this.mTags = aTags;
        }

        @Override
        public boolean isTrue(OreDictPrefix aPrefix) {
            return aPrefix.containsAll(this.mTags);
        }
    }
}

