/*
 * Decompiled with CFR 0.152.
 */
package gregapi.damage;

import gregapi.damage.DamageSourceAlcohol;
import gregapi.damage.DamageSourceBumble;
import gregapi.damage.DamageSourceCaffeine;
import gregapi.damage.DamageSourceChem;
import gregapi.damage.DamageSourceCombat;
import gregapi.damage.DamageSourceCrusher;
import gregapi.damage.DamageSourceDehydration;
import gregapi.damage.DamageSourceExploding;
import gregapi.damage.DamageSourceFat;
import gregapi.damage.DamageSourceFrost;
import gregapi.damage.DamageSourceHeat;
import gregapi.damage.DamageSourceShredder;
import gregapi.damage.DamageSourceSpike;
import gregapi.damage.DamageSourceSugar;
import gregapi.util.UT;
import ic2.api.info.Info;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class DamageSources {
    public static DamageSource getElectricDamage() {
        try {
            return Info.DMG_ELECTRIC;
        }
        catch (Throwable throwable) {
            return DamageSources.getHeatDamage();
        }
    }

    public static DamageSource getRadioactiveDamage() {
        try {
            return Info.DMG_RADIATION;
        }
        catch (Throwable throwable) {
            return DamageSources.getHeatDamage();
        }
    }

    public static DamageSource getNukeExplosionDamage() {
        try {
            return Info.DMG_NUKE_EXPLOSION;
        }
        catch (Throwable throwable) {
            return DamageSources.getHeatDamage();
        }
    }

    public static DamageSource getExplodingDamage() {
        return new DamageSourceExploding();
    }

    public static DamageSource getCombatDamage(String aType, EntityLivingBase aPlayer, IChatComponent aDeathMessage) {
        return DamageSources.getCombatDamage(aType, aPlayer, aDeathMessage, false);
    }

    public static DamageSource getCombatDamage(String aType, EntityLivingBase aPlayer, IChatComponent aDeathMessage, boolean aBeheading) {
        return new DamageSourceCombat(aType, aPlayer, aDeathMessage, aBeheading);
    }

    public static DamageSource getSpikeDamage() {
        return new DamageSourceSpike();
    }

    public static DamageSource getShredderDamage() {
        return new DamageSourceShredder();
    }

    public static DamageSource getCrusherDamage() {
        return new DamageSourceCrusher();
    }

    public static DamageSource getHeatDamage() {
        return new DamageSourceHeat();
    }

    public static DamageSource getFrostDamage() {
        return new DamageSourceFrost();
    }

    public static DamageSource getChemDamage() {
        return new DamageSourceChem();
    }

    public static DamageSource getBumbleDamage() {
        return new DamageSourceBumble();
    }

    public static DamageSource getAlcoholDamage() {
        return new DamageSourceAlcohol();
    }

    public static DamageSource getCaffeineDamage() {
        return new DamageSourceCaffeine();
    }

    public static DamageSource getDehydrationDamage() {
        return new DamageSourceDehydration();
    }

    public static DamageSource getSugarDamage() {
        return new DamageSourceSugar();
    }

    public static DamageSource getFatDamage() {
        return new DamageSourceFat();
    }

    public static IChatComponent getDeathMessage(EntityLivingBase aPlayer, Entity aEntity, String aMessage) {
        return DamageSources.getDeathMessage(aPlayer, aEntity, UT.Code.stringValidate(aPlayer.func_70005_c_(), "Someone"), UT.Code.stringValidate(aEntity.func_70005_c_(), "Someone"), aMessage);
    }

    public static IChatComponent getDeathMessage(EntityLivingBase aPlayer, Entity aEntity, String aNamePlayer, String aNameEntity, String aMessage) {
        if (UT.Code.stringInvalid(aNamePlayer) || UT.Code.stringInvalid(aEntity)) {
            return new ChatComponentText("Death Message lacks names of involved People");
        }
        aNamePlayer = aNamePlayer.trim();
        aNameEntity = aNameEntity.trim();
        if (aNamePlayer.equalsIgnoreCase("CrazyJ84") || aNamePlayer.equalsIgnoreCase("CrazyJ1984")) {
            if (aNameEntity.equalsIgnoreCase("Bear989jr")) {
                return new ChatComponentText("<" + EnumChatFormatting.LIGHT_PURPLE + "Mrs. Crazy" + EnumChatFormatting.WHITE + "> Sorry " + EnumChatFormatting.RED + "Junior" + EnumChatFormatting.WHITE);
            }
            if (aNameEntity.equalsIgnoreCase("Bear989Sr")) {
                return new ChatComponentText("<" + EnumChatFormatting.LIGHT_PURPLE + "Mrs. Crazy" + EnumChatFormatting.WHITE + "> Hush it!, " + EnumChatFormatting.RED + "Bear" + EnumChatFormatting.WHITE + "!");
            }
        }
        if (aNamePlayer.equalsIgnoreCase("Bear989Sr") || aNamePlayer.equalsIgnoreCase("Bear989jr")) {
            // empty if block
        }
        if (UT.Code.stringValid(aMessage)) {
            return new ChatComponentText(aMessage.replace("[KILLER]", EnumChatFormatting.GREEN + aNamePlayer + EnumChatFormatting.WHITE).replace("[VICTIM]", EnumChatFormatting.RED + aNameEntity + EnumChatFormatting.WHITE));
        }
        if (aEntity instanceof EntityLivingBase) {
            return new EntityDamageSource(aPlayer instanceof EntityPlayer ? "player" : "mob", (Entity)aPlayer).func_151519_b((EntityLivingBase)aEntity);
        }
        if (aEntity instanceof EntityDragonPart) {
            return new EntityDamageSource(aPlayer instanceof EntityPlayer ? "player" : "mob", (Entity)aPlayer).func_151519_b((EntityLivingBase)((EntityDragonPart)aEntity).field_70259_a);
        }
        return new ChatComponentText(EnumChatFormatting.GREEN + aNamePlayer + EnumChatFormatting.WHITE + " has killed " + EnumChatFormatting.RED + aNameEntity + EnumChatFormatting.WHITE);
    }
}

