/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.ITileEntityItemPipe;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class CoverRetrieverItem
extends AbstractCoverAttachment {
    public static final ITexture sTextureInverted = BlockTextureDefault.get("machines/covers/retrieveritem/inverted");
    public static final ITexture sTextureNormal = BlockTextureDefault.get("machines/covers/retrieveritem/normal");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof ITileEntityItemPipe);
    }

    @Override
    public void onStoppedUpdate(byte aCoverSide, CoverData aData, boolean aStopped) {
        if (!aStopped) {
            aData.value(aCoverSide, (short)1);
        }
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && !aData.mStopped && (CS.SERVER_TIME % 20L == 15L || aData.mValues[aSide] != 0) && aData.mTileEntity instanceof ITileEntityItemPipe && ((ITileEntityItemPipe)((Object)aData.mTileEntity)).pipeCapacityCheck()) {
            aData.value(aSide, (short)0);
            ArrayListNoNulls<ITileEntityItemPipe> tUsedPipes = new ArrayListNoNulls<ITileEntityItemPipe>();
            ItemStack tStack = ST.load(aData.mNBTs[aSide], "gt.filter.item");
            ItemStackSet<ItemStackContainer> tFilter = ST.invalid(tStack) ? null : ST.hashset(tStack);
            DelegatorTileEntity<TileEntity> tTarget = aData.mTileEntity.getAdjacentTileEntity(aSide);
            for (ITileEntityItemPipe tPipe : UT.Code.sortByValuesAcending(ITileEntityItemPipe.Util.scanPipes((ITileEntityItemPipe)((Object)aData.mTileEntity), new HashMap<ITileEntityItemPipe, Long>(), 0L, true, false)).keySet()) {
                if (!((ArrayList)tUsedPipes).add(tPipe)) continue;
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (!tPipe.canAcceptItemsFrom(tSide, aData.mTileEntity) || tSide == aSide && tPipe == aData.mTileEntity) continue;
                    DelegatorTileEntity<IInventory> tDelegator = tPipe.getAdjacentInventory(tSide);
                    if (tDelegator.mTileEntity instanceof ITileEntityItemPipe || ST.move(tDelegator, tTarget, tFilter, false, false, aData.mVisuals[aSide] != 0, true, 64, 1, 64, 1) <= 0) continue;
                    for (ITileEntityItemPipe tUsedPipe : tUsedPipes) {
                        tUsedPipe.incrementTransferCounter(1L);
                    }
                    return;
                }
            }
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        ItemStack tStack = ST.load(aStack.func_77978_p(), "gt.filter.item");
        if (ST.valid(tStack)) {
            aList.add(LH.Chat.CYAN + tStack.func_82833_r());
        }
        aList.add(LH.Chat.ORANGE + "Not NBT sensitive!");
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver")) {
            aData.visual(aCoverSide, (short)(aData.mVisuals[aCoverSide] == 0 ? 1 : 0));
            if (aChatReturn != null) {
                aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Normal Filter" : "Inverted Filter");
            }
            return 1000L;
        }
        if (aTool.equals("softhammer")) {
            aData.mNBTs[aCoverSide] = null;
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (aData.mNBTs[aCoverSide] == null) {
                    aChatReturn.add("Filter is empty!");
                    aData.mNBTs[aCoverSide] = null;
                } else {
                    ItemStack tStack = ST.load(aData.mNBTs[aCoverSide], "gt.filter.item");
                    if (ST.invalid(tStack)) {
                        aChatReturn.add("Filter is empty!");
                        aData.mNBTs[aCoverSide] = null;
                    } else {
                        aChatReturn.add("Filters for: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + LH.Chat.CYAN + ST.meta_(tStack));
                    }
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onCoverClickedRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        ItemStack tStack;
        if (aPlayer instanceof EntityPlayer && aData.mTileEntity.isServerSide() && (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].func_74764_b("gt.filter.item")) && ST.valid(tStack = ST.make(((EntityPlayer)aPlayer).func_71045_bC(), null, null))) {
            aData.mNBTs[aCoverSide] = ST.save("gt.filter.item", tStack);
            UT.Sounds.send("random.click", aData.mTileEntity);
            UT.Entities.sendchat((Object)aPlayer, "Filters for: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + LH.Chat.CYAN + ST.meta_(tStack));
        }
        return true;
    }

    @Override
    public boolean interceptItemInsert(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aCoverSide == aSide;
    }

    @Override
    public boolean interceptItemExtract(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aCoverSide == aSide;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return CS.ALONG_AXIS[aCoverSide][aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted) : BACKGROUND_COVER;
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }
}

