/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverControllerCovers
extends AbstractCoverAttachment {
    public static final ITexture sTextureBackground = BlockTextureDefault.get("machines/covers/coverswitch/base");
    public static final ITexture sTextureForeground = BlockTextureDefault.get("machines/covers/coverswitch/circuit");

    @Override
    public void onCoverRemove(byte aCoverSide, CoverData aData, Entity aPlayer) {
        super.onCoverRemove(aCoverSide, aData, aPlayer);
        aData.setStopped(this.getStateOnOff(aCoverSide, aData));
    }

    @Override
    public void onCoverPlaced(byte aCoverSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        super.onCoverPlaced(aCoverSide, aData, aPlayer, aCover);
        aData.setStopped(this.getStateOnOff(aCoverSide, aData));
    }

    @Override
    public void onTickPre(byte aCoverSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide) {
            aData.setStopped(this.getStateOnOff(aCoverSide, aData));
        }
    }

    @Override
    public boolean onCoverClickedRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        byte tSide = UT.Code.getSideWrenching(aSideClicked, aHitX, aHitY, aHitZ);
        if (tSide == aCoverSide || aSideClicked != aCoverSide) {
            return false;
        }
        if (aData.mBehaviours[tSide] != null) {
            return aData.mBehaviours[tSide].onCoverClickedRight(tSide, aData, aPlayer, aSideClicked, aHitX, aHitY, aHitZ);
        }
        return false;
    }

    @Override
    public boolean onCoverClickedLeft(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        byte tSide = UT.Code.getSideWrenching(aSideClicked, aHitX, aHitY, aHitZ);
        if (tSide == aCoverSide || aSideClicked != aCoverSide) {
            return false;
        }
        if (aData.mBehaviours[tSide] != null) {
            return aData.mBehaviours[tSide].onCoverClickedLeft(tSide, aData, aPlayer, aSideClicked, aHitX, aHitY, aHitZ);
        }
        return false;
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        byte tSide = UT.Code.getSideWrenching(aSideClicked, aHitX, aHitY, aHitZ);
        if (tSide == aCoverSide || aSideClicked != aCoverSide) {
            if (aTool.equals("screwdriver")) {
                aData.value(aCoverSide, (short)(aData.mValues[aCoverSide] ^ CS.B[0]));
                if (aChatReturn != null) {
                    aChatReturn.add((aData.mValues[aCoverSide] & CS.B[0]) != 0 ? "Covers work when Input is OFF" : "Covers work when Input is ON");
                }
                aData.setStopped(this.getStateOnOff(aCoverSide, aData));
                return 1000L;
            }
            if (aTool.equals("magnifyingglass")) {
                if (aChatReturn != null) {
                    aChatReturn.add((aData.mValues[aCoverSide] & CS.B[0]) != 0 ? "Covers work when Input is OFF" : "Covers work when Input is ON");
                }
                return 1L;
            }
            return 0L;
        }
        if (aData.mBehaviours[tSide] != null) {
            return aData.mBehaviours[tSide].onToolClick(tSide, aData, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSideClicked, aHitX, aHitY, aHitZ);
        }
        return 0L;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return sTextureForeground;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return aCoverSide != aTextureSide ? sTextureBackground : BlockTextureMulti.get(sTextureBackground, sTextureForeground);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return sTextureBackground;
    }

    public boolean getStateOnOff(byte aCoverSide, CoverData aData) {
        return UT.Code.bind1(aData.mTileEntity.getRedstoneIncoming(aCoverSide)) == (aData.mValues[aCoverSide] & CS.B[0]);
    }
}

