/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.item.bumble.IItemBumbleBee;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenHives
extends WorldgenObject {
    @SafeVarargs
    public WorldgenHives(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        int tX = aMinX + aRandom.nextInt(16);
        int tY = 0;
        int tZ = aMinZ + aRandom.nextInt(16);
        int tCount = 0;
        boolean rResult = false;
        switch (aDimType) {
            case 66: {
                tY = 16 + aRandom.nextInt(96);
                if (!IL.ERE_Umberstone.equal(WD.block((IBlockAccess)aWorld, tX, tY, tZ))) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aWorld, tX, tY, tZ, CS.DYE_INT_Brown, aRandom.nextBoolean() ? 500 : 0, aRandom) || rResult;
            }
            case 20: {
                tY = 16 + aRandom.nextInt(96);
                if (!IL.BTL_Betweenstone.equal(WD.block((IBlockAccess)aWorld, tX, tY, tZ))) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aWorld, tX, tY, tZ, CS.DYE_INT_Green, aRandom.nextBoolean() ? 500 : 0, aRandom) || rResult;
            }
            case 17: {
                tY = 16 + aRandom.nextInt(64);
                if (!IL.ATUM_Limestone.equal(WD.block((IBlockAccess)aWorld, tX, tY, tZ))) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aWorld, tX, tY, tZ, CS.DYE_INT_Yellow, 900, aRandom) || rResult;
            }
            case -33: 
            case -2: {
                tY = 16 + aRandom.nextInt(96);
                if (WD.block((IBlockAccess)aWorld, tX, tY, tZ) != Blocks.field_150424_aL) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aWorld, tX, tY, tZ, CS.DYE_INT_LightGray, 500, aRandom) || rResult;
            }
            case 6: {
                tY = 16 + aRandom.nextInt(96);
                if (WD.block((IBlockAccess)aWorld, tX, tY, tZ).func_149688_o() == Material.field_151578_c) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aWorld, tX, tY, tZ, CS.DYE_INT_Cyan, 0, aRandom) || rResult;
            }
            case -1: {
                tY = 16 + aRandom.nextInt(WD.bedrock(aWorld, tX, 255, tZ) ? 224 : 96);
                if (WD.block((IBlockAccess)aWorld, tX, tY, tZ) != Blocks.field_150424_aL) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aWorld, tX, tY, tZ, 0xAA0000, 300, aRandom) || rResult;
            }
            case 1: {
                if (aRandom.nextInt(3) > 0) {
                    return false;
                }
                for (tY = 16; tY < 128; ++tY) {
                    if (WD.block((IBlockAccess)aWorld, tX, tY, tZ) != Blocks.field_150377_bs) continue;
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                            return rResult;
                        }
                        if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                        ++tCount;
                    }
                    if (tCount == 5) {
                        rResult = this.placeHive(tRegistry, aWorld, tX, tY, tZ, 43690, 400, aRandom) || rResult;
                        break;
                    }
                    tCount = 0;
                }
                return rResult;
            }
            case -127: 
            case -6: 
            case 0: 
            case 7: 
            case 105: 
            case 0x7FFFFFFF: {
                for (tY = 8; tY < 28; ++tY) {
                    Block tBlock = WD.block((IBlockAccess)aWorld, tX, tY, tZ);
                    if (tBlock.func_149688_o() != Material.field_151576_e || !WD.opq(tBlock) || !WD.stone(tBlock, WD.meta((IBlockAccess)aWorld, tX, tY, tZ))) continue;
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                            tCount = 0;
                            break;
                        }
                        if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                        ++tCount;
                    }
                    if (tCount == 5) {
                        rResult = this.placeHive(tRegistry, aWorld, tX, tY, tZ, CS.DYE_INT_LightGray, 500, aRandom);
                        break;
                    }
                    tCount = 0;
                }
                int n = tY = aWorld.field_73011_w.field_76576_e ? 80 : aWorld.func_72800_K() - 50;
                while (tY > 2) {
                    Block tContact = aWorld.func_147439_a(tX, tY, tZ);
                    if (tContact.func_149688_o().func_76224_d()) {
                        return rResult;
                    }
                    if (tContact instanceof BlockStones && WD.meta((IBlockAccess)aWorld, tX, tY, tZ) != 0) {
                        return rResult;
                    }
                    if (tContact.func_149662_c() && !tContact.isLeaves((IBlockAccess)aWorld, tX, tY, tZ) && !tContact.isWood((IBlockAccess)aWorld, tX, tY, tZ) && tContact.func_149688_o() != Material.field_151588_w && tContact.func_149688_o() != Material.field_151575_d && tContact.func_149688_o() != Material.field_151584_j) {
                        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_DOWN) {
                            Block tBlock = aWorld.func_147439_a(tX + CS.OFFX[tSide], tY - 1 + CS.OFFY[tSide], tZ + CS.OFFZ[tSide]);
                            if (WD.hasCollide(aWorld, tX + CS.OFFX[tSide], tY - 1 + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], tBlock)) continue;
                            if (tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i || tBlock instanceof BlockWaterlike) {
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_LightBlue, 100, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_MAGICAL.contains(tName) || aDimType == 105 && !aRandom.nextBoolean()) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Purple, 200, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_VOLCANIC.contains(tName)) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Black, 300, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_END.contains(tName)) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, 43690, 400, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_NETHER.contains(tName)) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, 0xAA0000, 300, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_SHROOM.contains(tName)) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Pink, 800, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_OCEAN_BEACH.contains(tName) && !CS.BIOMES_LAKE.contains(tName)) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_LightBlue, 100, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_JUNGLE.contains(tName)) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Green, 600, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_FROZEN.contains(tName)) continue;
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_White, 700, aRandom) || rResult;
                            }
                            if (tContact == Blocks.field_150391_bh) {
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Pink, 800, aRandom) || rResult;
                            }
                            if (tContact == Blocks.field_150354_m && aWorld.func_72805_g(tX, tY, tZ) == 1) {
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Red, 900, aRandom) || rResult;
                            }
                            if (tContact == Blocks.field_150322_A || tContact.func_149688_o() == Material.field_151595_p) {
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Yellow, 900, aRandom) || rResult;
                            }
                            if (tContact == Blocks.field_150351_n || tContact.func_149688_o() == Material.field_151576_e) {
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_LightGray, 500, aRandom) || rResult;
                            }
                            if (tContact == Blocks.field_150349_c || tContact.func_149688_o() == Material.field_151577_b) {
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, 0xFFDD99, 0, aRandom) || rResult;
                            }
                            if (tContact == Blocks.field_150346_d || tContact.func_149688_o() == Material.field_151578_c) {
                                return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Brown, 0, aRandom) || rResult;
                            }
                            return this.placeHive(tRegistry, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Purple, 200, aRandom) || rResult;
                        }
                        return rResult;
                    }
                    --tY;
                }
                return rResult;
            }
        }
        return rResult;
    }

    public boolean placeHive(MultiTileEntityRegistry aRegistry, World aWorld, int aX, int aY, int aZ, int aColor, int aSpeciesID, Random aRandom) {
        NBTTagCompound aBumbleTag = IItemBumbleBee.Util.getBumbleGenes(WD.envTemp(aWorld, aX, aY, aZ), aWorld.func_72807_a(aX, aZ), !aWorld.field_73011_w.field_76576_e && aWorld.func_72874_g(aX, aZ) <= aY + 5, aRandom);
        return aRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, (short)32755, UT.NBT.make("gt.color", (Object)aColor, "gt.invlist", UT.NBT.makeInv(((IItemBumbleBee)((Object)CS.ItemsGT.BUMBLEBEES)).bumbleProductStack(CS.NI, (short)aSpeciesID, UT.Code.units(IItemBumbleBee.Util.getWorkForce(aBumbleTag), 10000L, 10L, true), 0), IItemBumbleBee.Util.setBumbleTag(ST.make(CS.ItemsGT.BUMBLEBEES, 1L, (long)(aSpeciesID + 1)), aBumbleTag), IItemBumbleBee.Util.setBumbleTag(ST.make(CS.ItemsGT.BUMBLEBEES, IItemBumbleBee.Util.getOffspring(aBumbleTag), (long)aSpeciesID), aBumbleTag)), "gt.painted", true), false, true);
    }
}

