/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.RM;
import gregapi.fluid.FluidTankGT;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityJuicer
extends TileEntityBase07Paintable
implements ITileEntityQuickObstructionCheck,
IFluidHandler,
ITileEntityConnectedTank,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips {
    protected short mDisplay = 0;
    protected short oDisplay = (short)-1;
    protected Recipe.RecipeMap mRecipes = RM.Juicer;
    protected Recipe mLastRecipe = null;
    protected FluidTankGT[] mTanks = CS.ZL_FT;
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/sides");
    public static IIconContainer sTextureInsides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/insides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/bottom");
    public static IIconContainer sTextureMiddleTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/middletop");
    public static IIconContainer sTextureMiddleSide = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/colored/middleside");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/sides");
    public static IIconContainer sOverlayInsides = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/insides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/bottom");
    public static IIconContainer sOverlayMiddleTop = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/middletop");
    public static IIconContainer sOverlayMiddleSide = new Textures.BlockIcons.CustomIcon("machines/tools/juicer/overlay/middleside");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.recipemap")) {
            this.mRecipes = Recipe.RecipeMap.RECIPE_MAPS.get(aNBT.func_74779_i("gt.recipemap"));
        }
        this.mTanks = new FluidTankGT[this.mRecipes.mOutputFluidCount];
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i] = new FluidTankGT(1000000L).readFromNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        for (int i = 0; i < this.mTanks.length; ++i) {
            this.mTanks[i].writeToNBT(aNBT, "gt.tank." + i);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes") + ": " + LH.Chat.WHITE + LH.get(this.mRecipes.mNameInternal));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.juicer.usage"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("plunger")) {
            this.updateInventory();
            for (FluidTankGT tTank : this.mTanks) {
                long rAmount = CS.GarbageGT.trash(tTank, 1000L);
                if (rAmount <= 0L) continue;
                return rAmount;
            }
            this.updateAdjacentInventories();
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                for (FluidTankGT tTank : this.mTanks) {
                    aChatReturn.add(tTank.content());
                }
            }
            return this.mTanks.length;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            this.mDisplay = 0;
            for (FluidTankGT tTank : this.mTanks) {
                if (!tTank.has()) continue;
                this.mDisplay = (short)(tTank.getFluid().getFluidID() + 1);
                break;
            }
        }
    }

    protected boolean canOutput(Recipe aRecipe) {
        for (int i = 0; i < this.mTanks.length && i < aRecipe.mFluidOutputs.length; ++i) {
            if (!this.mTanks[i].has() || !aRecipe.mNeedsEmptyOutput && (aRecipe.mFluidOutputs[i] == null || this.mTanks[i].contains(aRecipe.mFluidOutputs[i]) && FL.temperature(aRecipe.mFluidOutputs[i]) < this.mMaterial.mMeltingPoint - 100L && !FL.lighter(aRecipe.mFluidOutputs[i]) && !this.mTanks[i].has(Math.max(1000, 1 + aRecipe.mFluidOutputs[i].amount)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        float[] tCoords;
        if (this.isServerSide()) {
            float[] tCoords2;
            ItemStack aStack = aPlayer.func_71045_bC();
            if (CS.SIDES_TOP[aSide] && (tCoords2 = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] <= CS.PX_P[4] && tCoords2[1] <= CS.PX_P[4]) {
                return true;
            }
            if (!UT.Entities.isPlayer(aPlayer)) {
                return true;
            }
            Recipe tRecipe = this.mRecipes.findRecipe((IHasWorldAndCoords)this, this.mLastRecipe, false, CS.V[1], CS.NI, CS.ZL_FS, aStack);
            if (tRecipe != null) {
                if (tRecipe.mCanBeBuffered) {
                    this.mLastRecipe = tRecipe;
                }
                if (this.canOutput(tRecipe) && tRecipe.isRecipeInputEqual(true, false, CS.ZL_FS, aStack)) {
                    for (ItemStack tStack : tRecipe.getOutputs()) {
                        ST.give((Entity)aPlayer, tStack, true);
                    }
                    FluidStack[] tOutputFluids = tRecipe.getFluidOutputs();
                    for (int i = 0; i < this.mTanks.length && i < tOutputFluids.length; ++i) {
                        this.mTanks[i].fill(tOutputFluids[i], true);
                    }
                    UT.Entities.exhaust(aPlayer, (float)tRecipe.getAbsoluteTotalPower() / 10000.0f);
                    UT.Sounds.send("mob.slime.big", this, false);
                    this.updateInventory();
                    this.updateAdjacentInventories();
                    return true;
                }
            }
            ItemStack tStack = null;
            if (aStack != null) {
                for (FluidTankGT tTank : this.mTanks) {
                    tStack = FL.fill(tTank, ST.amount(1L, aStack), true, true, true, true);
                    if (tStack == null) continue;
                    --aStack.field_77994_a;
                    ST.give((Entity)aPlayer, tStack, true);
                    return true;
                }
            }
        } else if (CS.SIDES_TOP[aSide] && (tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ))[0] <= CS.PX_P[4] && tCoords[1] <= CS.PX_P[4]) {
            this.mRecipes.openNEI();
            return true;
        }
        return true;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplay != this.oDisplay;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplay = this.mDisplay;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketByteArray(aSendAll, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1));
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        if (aData.length > 1) {
            this.mDisplay = UT.Code.combine(aData[0], aData[1]);
        }
        if (aData.length > 4) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
        }
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        if (aFluidToDrain == null) {
            for (int i = 0; i < this.mTanks.length; ++i) {
                int j = ((int)(CS.SERVER_TIME / 20L) + i) % this.mTanks.length;
                if (!this.mTanks[j].has()) continue;
                return this.mTanks[j];
            }
        } else {
            for (int i = 0; i < this.mTanks.length; ++i) {
                if (!this.mTanks[i].contains(aFluidToDrain)) continue;
                return this.mTanks[i];
            }
        }
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTanks;
    }

    @Override
    public boolean breakBlock() {
        CS.GarbageGT.trash(this.mTanks);
        return super.breakBlock();
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 8;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[12], CS.PX_N[12], CS.PX_N[2]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[12]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[12], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[12], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[15], CS.PX_N[2]);
                return true;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[13], CS.PX_N[2]);
                return true;
            }
            case 6: {
                this.box(aBlock, CS.PX_P[6], CS.PX_P[0], CS.PX_P[6], CS.PX_N[6], CS.PX_N[9], CS.PX_N[6]);
                return true;
            }
            case 7: {
                this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[12], CS.PX_N[12] + 0.001f, CS.PX_N[12]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                return 5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 2: {
                return 4 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (5 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 1: {
                return 3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 3: {
                return 2 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa), BlockTextureDefault.get(sOverlayInsides)) : (3 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa), BlockTextureDefault.get(sOverlaySides)) : (1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : null));
            }
            case 4: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa), BlockTextureDefault.get(sOverlayTop)) : (0 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa), BlockTextureDefault.get(sOverlayBottom)) : null);
            }
            case 5: {
                if (this.mDisplay <= 0 || 1 != aSide) {
                    return null;
                }
                Fluid tFluid = FL.fluid(this.mDisplay - 1);
                return tFluid == null ? BlockTextureCopied.get(Blocks.field_150355_j, 6, 0, CS.UNCOLOURED, false, false, false) : BlockTextureFluid.get(FL.make(tFluid, 1000L));
            }
            case 6: {
                return 1 == aSide ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureMiddleTop, this.mRGBa), BlockTextureDefault.get(sOverlayMiddleTop)) : (0 == aSide ? null : BlockTextureMulti.get(BlockTextureDefault.get(sTextureMiddleSide, this.mRGBa), BlockTextureDefault.get(sOverlayMiddleSide)));
            }
            case 7: {
                return 1 == aSide ? BI.nei() : null;
            }
        }
        return null;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        this.box(aAABB, aList, CS.PX_P[12], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[12], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[12], CS.PX_N[12], CS.PX_N[2]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[12]);
        this.box(aAABB, aList, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[15], CS.PX_N[2]);
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[2], CS.PX_P[0], CS.PX_P[2], CS.PX_N[2], CS.PX_N[12], CS.PX_N[2]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.5f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_P[12] : CS.PX_P[2];
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        return 0;
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (aFluid == CS.NF) {
            return 0;
        }
        for (FluidTankGT tTank : this.mTanks) {
            if (!tTank.contains(aFluid) || !tTank.has(aOnlyRemoveIfItCanRemoveAllAtOnce ? (long)aFluid.amount : 1L)) continue;
            return (int)tTank.remove(aFluid.amount);
        }
        return 0;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        if (aFluid == CS.NF) {
            return 0L;
        }
        long rAmount = 0L;
        for (FluidTankGT tTank : this.mTanks) {
            if (!tTank.contains(aFluid)) continue;
            rAmount += tTank.amount();
        }
        return rAmount;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.juicer";
    }
}

