/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictPrefix;
import gregapi.render.ITexture;
import gregapi.util.UT;
import gregtech.tileentity.tools.MultiTileEntityMold;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityBasin
extends MultiTileEntityMold {
    @Override
    public OreDictPrefix getMoldRecipe(int aShape) {
        return OP.blockSolid;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mold") + " " + this.getMoldRecipe((int)0).mNameLocal);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.getMoldMaxTemperature() + " K)");
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.contact"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.pincers.to.take"));
    }

    @Override
    public boolean isMoldInputSide(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (CS.SIDES_TOP[aSide]) {
            if (this.isServerSide()) {
                this.pickUpItem(aPlayer, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + this.mTemperature + "K");
            }
            return 10000L;
        }
        if (aTool.equals("pincers") && aPlayer instanceof EntityPlayer && CS.SIDES_TOP[aSide] && this.pickUpItem((EntityPlayer)aPlayer, false)) {
            return 2000L;
        }
        if (aTool.equals("chisel") || aTool.equals("softhammer") || aTool.equals("magnifyingglass") || aTool.equals("wrench") || aTool.equals("monkeywrench") || aTool.equals("screwdriver") || aTool.equals("rotator")) {
            return 0L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return this.getClientDataPacketByteArray(true, UT.Code.toByteS(this.mDisplay, 0), UT.Code.toByteS(this.mDisplay, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        super.getRenderPasses2(aBlock, aShouldSideBeRendered);
        return 6;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[15], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[15]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[15], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[15], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[15], CS.PX_N[0]);
                return true;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[1], CS.PX_N[0]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: 
            case 2: {
                return CS.SIDES_AXIS_Z[aSide] || aSide == 0 ? null : this.mTexture;
            }
            case 1: 
            case 3: {
                return CS.SIDES_AXIS_X[aSide] || aSide == 0 ? null : this.mTexture;
            }
            case 4: {
                return CS.SIDES_VERTICAL[aSide] ? this.mTexture : null;
            }
            case 5: {
                return CS.SIDES_TOP[aSide] ? this.mTextureMolten : null;
            }
        }
        return this.mTexture;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[2], CS.PX_P[2], CS.PX_P[2], CS.PX_N[2], CS.PX_N[2], CS.PX_N[2]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
    }

    @Override
    public boolean addDefaultCollisionBoxToList() {
        return false;
    }

    @Override
    public void addCollisionBoxesToList2(AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        this.box(aAABB, aList, CS.PX_P[14], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[1], CS.PX_N[1]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[14], CS.PX_N[1], CS.PX_N[1], CS.PX_N[1]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[14], CS.PX_N[1], CS.PX_N[1]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[1], CS.PX_N[14]);
        this.box(aAABB, aList, CS.PX_P[1], CS.PX_P[1], CS.PX_P[1], CS.PX_N[1], CS.PX_N[14], CS.PX_N[1]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 1.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_BOTTOM_HORIZONTAL[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.basin";
    }
}

