/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.sensors;

import gregapi.data.BI;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.IIconContainer;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntitySensorTE;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityKiloBucketometer
extends MultiTileEntitySensorTE {
    public static IIconContainer sTextureFront;
    public static IIconContainer sTextureBack;
    public static IIconContainer sTextureSide;
    public static IIconContainer sOverlayFront;
    public static IIconContainer sOverlayBack;
    public static IIconContainer sOverlaySide;

    @Override
    public String getSensorDescription() {
        return LH.get("gt.tooltip.sensor.kilobucketometer");
    }

    @Override
    public long getCurrentValue(DelegatorTileEntity<TileEntity> aDelegator) {
        FluidTankInfo[] tInfo;
        if (aDelegator.mTileEntity instanceof IFluidHandler && (tInfo = ((IFluidHandler)aDelegator.mTileEntity).getTankInfo(CS.FORGE_DIR[aDelegator.mSideOfTileEntity])) != null) {
            long rFluid = 0L;
            for (FluidTankInfo tTank : tInfo) {
                if (tTank == null || tTank.fluid == null) continue;
                rFluid += (long)tTank.fluid.amount;
            }
            return rFluid / 1000000L;
        }
        Block tBlock = aDelegator.getBlock();
        if (tBlock instanceof IFluidBlock) {
            FluidStack tFluid = ((IFluidBlock)tBlock).drain(aDelegator.mWorld, aDelegator.mX, aDelegator.mY, aDelegator.mZ, false);
            return tFluid == null ? 0L : (long)(tFluid.amount / 1000000);
        }
        return 0L;
    }

    @Override
    public long getCurrentMax(DelegatorTileEntity<TileEntity> aDelegator) {
        FluidTankInfo[] tInfo;
        if (aDelegator.mTileEntity instanceof IFluidHandler && (tInfo = ((IFluidHandler)aDelegator.mTileEntity).getTankInfo(CS.FORGE_DIR[aDelegator.mSideOfTileEntity])) != null) {
            long rCapacity = 0L;
            for (FluidTankInfo tTank : tInfo) {
                if (tTank == null) continue;
                rCapacity += (long)tTank.capacity;
            }
            return rCapacity / 1000000L;
        }
        return 0L;
    }

    @Override
    public short[] getSymbolColor() {
        return CS.CA_BLUE_255;
    }

    @Override
    public IIconContainer getSymbolIcon() {
        return BI.CHAR_DECAMETER_3;
    }

    @Override
    public IIconContainer getTextureFront() {
        return sTextureFront;
    }

    @Override
    public IIconContainer getTextureBack() {
        return sTextureBack;
    }

    @Override
    public IIconContainer getTextureSide() {
        return sTextureSide;
    }

    @Override
    public IIconContainer getOverlayFront() {
        return sOverlayFront;
    }

    @Override
    public IIconContainer getOverlayBack() {
        return sOverlayBack;
    }

    @Override
    public IIconContainer getOverlaySide() {
        return sOverlaySide;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.redstone.sensors.kilobucketometer";
    }

    static {
        LH.add("gt.tooltip.sensor.kilobucketometer", "Measures Fluids (In Cubic Decameters)");
        sTextureFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/kilobucketometer/colored/front");
        sTextureBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/kilobucketometer/colored/back");
        sTextureSide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/kilobucketometer/colored/side");
        sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/kilobucketometer/overlay/front");
        sOverlayBack = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/kilobucketometer/overlay/back");
        sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/redstone/sensors/kilobucketometer/overlay/side");
    }
}

