/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.multiblocks.MultiTileEntityTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidStack;

public abstract class MultiTileEntityTank3x3x3
extends MultiTileEntityTank {
    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.tank3x3x3.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.tank3x3x3.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.tank3x3x3.3"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing);
        if (this.field_145850_b.func_72899_e(tX - 1, tY = this.getOffsetYN(this.mFacing), (tZ = this.getOffsetZN(this.mFacing)) - 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ - 1) && this.field_145850_b.func_72899_e(tX - 1, tY, tZ + 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ + 1)) {
            boolean tSuccess = true;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0) {
                            if (this.getAir(tX + i, tY + j, tZ + k)) {
                                this.field_145850_b.func_147468_f(tX + i, tY + j, tZ + k);
                                continue;
                            }
                            tSuccess = false;
                            continue;
                        }
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, this.mTankWalls, this.getMultiTileEntityRegistryID(), 0, -13, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing);
        int tY = this.getOffsetYN(this.mFacing);
        int tZ = this.getOffsetZN(this.mFacing);
        return aX >= tX - 1 && aY >= tY - 1 && aZ >= tZ - 1 && aX <= tX + 1 && aY <= tY + 1 && aZ <= tZ + 1;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        FluidStack tFluid;
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.checkStructure(false) && (tFluid = this.mTank.getFluid()) != null && tFluid.amount > 0) {
            if (FL.temperature(this.mTank) >= this.mMaterial.mMeltingPoint && this.meltdown()) {
                return;
            }
            if (!this.mMagicProof && FL.magic(tFluid)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
                int tX = this.getOffsetXN(this.mFacing);
                int tY = this.getOffsetYN(this.mFacing);
                int tZ = this.getOffsetZN(this.mFacing);
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (this.rng(3) != 0) continue;
                            WD.set(this.field_145850_b, tX + i, tY + j, tZ + k, FL.gas(tFluid) ? IL.TC_Flux_Gas.block() : IL.TC_Flux_Goo.block(), IL.TC_Flux_Goo.exists() ? 7L : 0L, 3L);
                        }
                    }
                }
                WD.set(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, FL.gas(tFluid) ? IL.TC_Flux_Gas.block() : IL.TC_Flux_Goo.block(), IL.TC_Flux_Goo.exists() ? 7L : 0L, 3L);
                return;
            }
            if (!this.mAcidProof && FL.acid(this.mTank)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
                int tX = this.getOffsetXN(this.mFacing);
                int tY = this.getOffsetYN(this.mFacing);
                int tZ = this.getOffsetZN(this.mFacing);
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (this.rng(3) != 0) continue;
                            this.field_145850_b.func_147468_f(tX + i, tY + j, tZ + k);
                        }
                    }
                }
                this.setToAir();
                return;
            }
            if (!this.mPlasmaProof && FL.plasma(this.mTank)) {
                CS.GarbageGT.trash(this.mTank);
                UT.Sounds.send("random.fizz", this, false);
            } else if (!this.mGasProof && FL.gas(this.mTank)) {
                CS.GarbageGT.trash(this.mTank);
                UT.Sounds.send("random.fizz", this, false);
            } else if (!this.allowFluid(tFluid)) {
                CS.GarbageGT.trash(this.mTank);
                UT.Sounds.send("random.fizz", this, false);
            } else if ((CS.SIDES_HORIZONTAL[this.mFacing] || FL.gas(this.mTank) || (FL.lighter(tFluid) ? CS.SIDES_TOP : CS.SIDES_BOTTOM)[this.mFacing]) && FL.move(this.mTank, this.getAdjacentTileEntity(this.mFacing)) > 0L) {
                this.updateInventory();
            }
        }
    }

    public boolean meltdown() {
        int tX = this.getOffsetXN(this.mFacing);
        int tY = this.getOffsetYN(this.mFacing);
        int tZ = this.getOffsetZN(this.mFacing);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    WD.burn(this.field_145850_b, tX + i, tY + j, tZ + k, false, false);
                    if (this.rng(4) != 0) continue;
                    this.field_145850_b.func_147465_d(tX + i, tY + j, tZ + k, (Block)Blocks.field_150480_ab, 0, 3);
                }
            }
        }
        if (FL.lava(this.mTank) && this.mTank.drainAll(1000L)) {
            this.field_145850_b.func_147465_d(tX, tY, tZ, (Block)Blocks.field_150356_k, 0, 3);
        }
        CS.GarbageGT.trash(this.mTank);
        this.setToFire();
        return true;
    }

    static {
        LH.add("gt.tooltip.multiblock.tank3x3x3.1", "3x3x3 Hollow of the corresponding Walls made of this Material");
        LH.add("gt.tooltip.multiblock.tank3x3x3.2", "This Block centered on Side/Top/Bottom and facing outwards");
        LH.add("gt.tooltip.multiblock.tank3x3x3.3", "Auto-Emits Fluids from the Main Block if not against Gravity");
    }
}

