/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.tileentity.ITileEntityFunnelAccessible;
import gregapi.tileentity.ITileEntityTapAccessible;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MultiTileEntityTank
extends TileEntityBase10MultiBlockBase
implements IMultiBlockFluidHandler,
IFluidHandler,
ITileEntityFunnelAccessible,
ITileEntityTapAccessible {
    public FluidTankGT mTank = new FluidTankGT(432000L);
    public short mTankWalls = (short)18002;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;
    public boolean mPlasmaProof = false;
    public boolean mMagicProof = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.design")) {
            this.mTankWalls = aNBT.func_74765_d("gt.design");
        }
        if (aNBT.func_74764_b("gt.gasproof")) {
            this.mGasProof = aNBT.func_74767_n("gt.gasproof");
        }
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
        if (aNBT.func_74764_b("gt.magicproof")) {
            this.mMagicProof = aNBT.func_74767_n("gt.magicproof");
        }
        if (aNBT.func_74764_b("gt.plasmaproof")) {
            this.mPlasmaProof = aNBT.func_74767_n("gt.plasmaproof");
        }
        this.mTank.setCapacity(aNBT.func_74763_f("gt.tankcap"));
        this.mTank.readFromNBT(aNBT, "gt.tank");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        this.mTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + this.mTank.contentcap());
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.funnel.tap.tank"));
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.no.powerconducting.fluids"));
        if (this.onlySimple()) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.only.simple"));
        }
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mPlasmaProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.plasma"));
        }
        if (this.mMagicProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.magic"));
        }
        aList.add(LH.Chat.DRED + LH.get("gt.lang.hazard.meltdown") + " (" + this.mMaterial.mMeltingPoint + " K)");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("thermometer")) {
            if (aChatReturn != null) {
                aChatReturn.add("Temperature: " + FL.temperature(this.mTank) + "K");
            }
            return 10000L;
        }
        if (aTool.equals("plunger")) {
            return CS.GarbageGT.trash(this.mTank, 1000L);
        }
        return 0L;
    }

    @Override
    public void onMagnifyingGlass2(List<String> aChatReturn) {
        aChatReturn.add(this.mTank.contentcap());
    }

    public boolean allowFluid(FluidStack aFluid) {
        return !FL.powerconducting(aFluid) && FL.temperature(aFluid) < this.mMaterial.mMeltingPoint && (!this.onlySimple() || FL.simple(aFluid));
    }

    public boolean onlySimple() {
        return false;
    }

    @Override
    public boolean breakBlock() {
        CS.GarbageGT.trash(this.mTank);
        return super.breakBlock();
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return this.mTank.fill(aFluid, aDoFill);
    }

    @Override
    public FluidStack tapDrain(byte aSide, int aMaxDrain, boolean aDoDrain) {
        return this.mTank.drain(aMaxDrain, aDoDrain);
    }

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.mTank;
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.mTank;
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.mTank.AS_ARRAY;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTank;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTank.AS_ARRAY;
    }
}

