/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.LH;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockMachine;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityImplosionCompressor
extends TileEntityBase10MultiBlockMachine {
    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing);
        if (this.field_145850_b.func_72899_e(tX - 1, tY = this.field_145848_d + 1, (tZ = this.getOffsetZN(this.mFacing)) - 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ - 1) && this.field_145850_b.func_72899_e(tX - 1, tY, tZ + 1) && this.field_145850_b.func_72899_e(tX + 1, tY, tZ + 1)) {
            boolean tSuccess = true;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0) {
                            if (this.getAir(tX + i, tY + j, tZ + k)) {
                                this.field_145850_b.func_147468_f(tX + i, tY + j, tZ + k);
                                continue;
                            }
                            tSuccess = false;
                            continue;
                        }
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18023, this.getMultiTileEntityRegistryID(), 0, -64, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public void onProcessStarted() {
        UT.Sounds.send("random.explode", this, false);
        super.onProcessStarted();
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.implosioncompressor.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.implosioncompressor.2"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing, 1);
        int tY = this.field_145848_d;
        int tZ = this.getOffsetZN(this.mFacing, 1);
        return aX >= tX - 1 && aY >= tY && aZ >= tZ - 1 && aX <= tX + 1 && aY <= tY + 2 && aZ <= tZ + 1;
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getFluidOutputTarget(byte aSide, Fluid aOutput) {
        return this.getAdjacentTank((byte)0);
    }

    @Override
    public DelegatorTileEntity<TileEntity> getItemOutputTarget(byte aSide) {
        return this.getAdjacentTileEntity((byte)0);
    }

    @Override
    public DelegatorTileEntity<IInventory> getItemInputTarget(byte aSide) {
        return null;
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getFluidInputTarget(byte aSide) {
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.implosioncompressor";
    }

    static {
        LH.add("gt.tooltip.multiblock.implosioncompressor.1", "3x3x3 Hollow of 25 Dense Tungstensteel Walls filled with Air");
        LH.add("gt.tooltip.multiblock.implosioncompressor.2", "Main Block centered on Side-Bottom and facing outwards");
    }
}

