/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.fluids;

import gregapi.block.IBlock;
import gregapi.block.IBlockOnHeadInside;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.item.IItemGT;
import gregapi.lang.LanguageHandler;
import gregapi.render.RendererBlockFluid;
import gregapi.tileentity.data.ITileEntitySurface;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public abstract class BlockWaterlike
extends BlockFluidClassic
implements IBlock,
IItemGT,
IBlockOnHeadInside {
    public static int WATER_UPDATE_FLAGS = 0;
    public final Fluid mFluid;
    public List<int[]> mEffects = new ArrayListNoNulls<int[]>();

    public BlockWaterlike(String aName, Fluid aFluid, boolean aFlowsOut, boolean aHide) {
        super(aFluid, Material.field_151586_h);
        this.mFluid = aFluid;
        this.quantaPerBlock = aFlowsOut ? 8 : 3;
        this.quantaPerBlockFloat = this.quantaPerBlock;
        this.func_149752_b(30.0f);
        this.func_149663_c(aName);
        this.func_149713_g(3);
        ST.register((Block)this, aName, ItemBlock.class);
        LH.add(this.func_149739_a(), this.func_149732_F());
        LanguageHandler.set(this.func_149732_F(), this.func_149732_F());
        this.setFluidStack(FL.make(aFluid, 1000L));
        if (aHide) {
            ST.hide((Block)this);
        }
    }

    public FluidStack drain(World aWorld, int aX, int aY, int aZ, boolean aDoDrain) {
        if (aDoDrain) {
            aWorld.func_147465_d(aX, aY, aZ, CS.NB, 0, 2);
        }
        return FL.make(this.getFluid(), 1000L);
    }

    public boolean canDrain(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ) == 0;
    }

    public void updateFlow(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        int tFlowMeta;
        int quantaRemaining = this.quantaPerBlock - WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            if (aWorld.func_147439_a(aX, aY - this.densityDir, aZ) instanceof BlockWaterlike || aWorld.func_147439_a(aX - 1, aY - this.densityDir, aZ) instanceof BlockWaterlike || aWorld.func_147439_a(aX + 1, aY - this.densityDir, aZ) instanceof BlockWaterlike || aWorld.func_147439_a(aX, aY - this.densityDir, aZ - 1) instanceof BlockWaterlike || aWorld.func_147439_a(aX, aY - this.densityDir, aZ + 1) instanceof BlockWaterlike) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX - 1, aY, aZ, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX + 1, aY, aZ, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX, aY, aZ - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)aWorld, aX, aY, aZ + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    aWorld.func_147468_f(aX, aY, aZ);
                } else {
                    aWorld.func_72921_c(aX, aY, aZ, this.quantaPerBlock - expQuanta, 3);
                    aWorld.func_147464_a(aX, aY, aZ, (Block)this, this.tickRate);
                    aWorld.func_147459_d(aX, aY, aZ, (Block)this);
                }
            }
        }
        if (this.canDisplace((IBlockAccess)aWorld, aX, aY + this.densityDir, aZ)) {
            if (this.displaceIfPossible(aWorld, aX, aY + this.densityDir, aZ)) {
                aWorld.func_147465_d(aX, aY + this.densityDir, aZ, (Block)this, 1, WATER_UPDATE_FLAGS | 1);
            }
            return;
        }
        int n = tFlowMeta = aWorld.func_147439_a(aX, aY - this.densityDir, aZ) instanceof BlockWaterlike ? 1 : this.quantaPerBlock - quantaRemaining + 1;
        if (tFlowMeta >= this.quantaPerBlock) {
            return;
        }
        if (aWorld.func_72899_e(aX, aY, aZ - 1) && this.displaceIfPossible(aWorld, aX, aY, aZ - 1)) {
            aWorld.func_147465_d(aX, aY, aZ - 1, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
        if (aWorld.func_72899_e(aX, aY, aZ + 1) && this.displaceIfPossible(aWorld, aX, aY, aZ + 1)) {
            aWorld.func_147465_d(aX, aY, aZ + 1, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
        if (aWorld.func_72899_e(aX - 1, aY, aZ) && this.displaceIfPossible(aWorld, aX - 1, aY, aZ)) {
            aWorld.func_147465_d(aX - 1, aY, aZ, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
        if (aWorld.func_72899_e(aX + 1, aY, aZ) && this.displaceIfPossible(aWorld, aX + 1, aY, aZ)) {
            aWorld.func_147465_d(aX + 1, aY, aZ, (Block)this, tFlowMeta, WATER_UPDATE_FLAGS | 1);
        }
    }

    public Vec3 getFlowVector(IBlockAccess aWorld, int aX, int aY, int aZ) {
        Vec3 rVector = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        int tDecay = this.quantaPerBlock - this.getQuantaValue(aWorld, aX, aY, aZ);
        for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
            int tX = aX + CS.OFFX[tSide];
            int tZ = aZ + CS.OFFZ[tSide];
            int tOtherDecay = this.quantaPerBlock - this.getQuantaValue(aWorld, tX, aY, tZ);
            if (tOtherDecay >= this.quantaPerBlock) {
                if (aWorld.func_147439_a(tX, aY, tZ).func_149688_o().func_76230_c() || (tOtherDecay = this.quantaPerBlock - this.getQuantaValue(aWorld, tX, aY - 1, tZ)) < 0) continue;
                int tPower = tOtherDecay - (tDecay - this.quantaPerBlock);
                rVector = rVector.func_72441_c((double)((tX - aX) * tPower), 0.0, (double)((tZ - aZ) * tPower));
                continue;
            }
            if (tOtherDecay < 0) continue;
            int power = tOtherDecay - tDecay;
            rVector = rVector.func_72441_c((double)((tX - aX) * power), 0.0, (double)((tZ - aZ) * power));
        }
        if (aWorld.func_147439_a(aX, aY + 1, aZ) instanceof BlockWaterlike && (this.func_149747_d(aWorld, aX, aY, aZ - 1, 2) || this.func_149747_d(aWorld, aX, aY, aZ + 1, 3) || this.func_149747_d(aWorld, aX - 1, aY, aZ, 4) || this.func_149747_d(aWorld, aX + 1, aY, aZ, 5) || this.func_149747_d(aWorld, aX, aY + 1, aZ - 1, 2) || this.func_149747_d(aWorld, aX, aY + 1, aZ + 1, 3) || this.func_149747_d(aWorld, aX - 1, aY + 1, aZ, 4) || this.func_149747_d(aWorld, aX + 1, aY + 1, aZ, 5))) {
            rVector = rVector.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
        }
        return rVector.func_72432_b();
    }

    public int getQuantaValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return 0;
        }
        if (aBlock == this) {
            return this.quantaPerBlock - aWorld.func_72805_g(aX, aY, aZ);
        }
        if (aBlock instanceof BlockWaterlike) {
            return 8 - aWorld.func_72805_g(aX, aY, aZ);
        }
        if (aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i) {
            return 8 - aWorld.func_72805_g(aX, aY, aZ);
        }
        return -1;
    }

    public boolean func_149646_a(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
        if (aBlock == CS.NB) {
            return true;
        }
        if (aBlock.func_149688_o() == Material.field_151586_h || WD.visOpq(aBlock)) {
            return false;
        }
        if (aBlock.isAir(aWorld, aX, aY, aZ)) {
            return true;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof ITileEntitySurface) {
            return !((ITileEntitySurface)tTileEntity).isSurfaceOpaque(CS.OPOS[aSide]);
        }
        return true;
    }

    public boolean isSourceBlock(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ) instanceof BlockWaterlike && aWorld.func_72805_g(aX, aY, aZ) == 0;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    public final String func_149739_a() {
        return FL.name(this.mFluid, false);
    }

    public String func_149732_F() {
        return FL.name(this.mFluid, true);
    }

    public void func_149651_a(IIconRegister aIconRegister) {
    }

    public int func_149645_b() {
        return RendererBlockFluid.RENDER_ID;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149717_k() {
        return 3;
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        return Blocks.field_150355_j.func_149691_a(aSide, aMeta);
    }

    public int func_149741_i(int aMeta) {
        return 0xFFFFFF;
    }

    public int func_149720_d(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return 0xFFFFFF;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return 0;
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return 0;
    }

    public boolean canDisplace(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return !aWorld.func_147439_a(aX, aY, aZ).func_149688_o().func_76224_d() && super.canDisplace(aWorld, aX, aY, aZ);
    }

    public boolean displaceIfPossible(World aWorld, int aX, int aY, int aZ) {
        return !aWorld.func_147439_a(aX, aY, aZ).func_149688_o().func_76224_d() && super.displaceIfPossible(aWorld, aX, aY, aZ);
    }

    public boolean func_149678_a(int aMeta, boolean aFullHit) {
        return aFullHit && aMeta == 0;
    }

    public boolean func_149655_b(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return !this.mEffects.isEmpty();
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149730_j() {
        return false;
    }

    public boolean func_149653_t() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean isAir(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return false;
    }

    public BlockWaterlike addEffect(int aEffectID, int aEffectDuration, int aEffectLevel) {
        this.mEffects.add(new int[]{aEffectID, aEffectDuration, aEffectLevel});
        return this;
    }

    @Override
    public void onHeadInside(EntityLivingBase aEntity, World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.field_72995_K && !this.mEffects.isEmpty() && (FL.gas(this.mFluid) ? !UT.Entities.isImmuneToBreathingGases(aEntity) : !UT.Entities.isWearingFullChemHazmat(aEntity))) {
            for (int[] tEffects : this.mEffects) {
                UT.Entities.applyPotion((Entity)aEntity, tEffects[0], tEffects[1], tEffects[2], false);
            }
            if (this.func_149688_o() != Material.field_151586_h && CS.SERVER_TIME % 20L == 0L) {
                aEntity.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
    }
}

