/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.tank;

import enviromine.handlers.EM_StatusManager;
import enviromine.trackers.EnviroDataTracker;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityItemInternal;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.fluid.FluidTankGT;
import gregapi.item.multiitem.food.FoodStatFluid;
import gregapi.tileentity.ITileEntityConnectedTank;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import ic2.api.crops.ICropTile;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import squeek.applecore.api.food.FoodValues;
import thaumcraft.common.tiles.TileCrucible;

public abstract class TileEntityBase08FluidContainer
extends TileEntityBase07Paintable
implements ITileEntityConnectedTank,
IMultiTileEntity.IMTE_GetMaxStackSize,
IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking,
IMultiTileEntity.IMTE_OnItemRightClick,
IMultiTileEntity.IMTE_OnItemUseFirst,
IMultiTileEntity.IMTE_AddToolTips,
IFluidContainerItem {
    public FluidTankGT mTank = new FluidTankGT(1000L);
    public boolean mLiquidProof = true;
    public boolean mGasProof = false;
    public boolean mAcidProof = false;
    public boolean mPlasmaProof = false;
    public boolean mMagicProof = false;
    public long mTemperatureMax = 0L;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.gasproof")) {
            this.mGasProof = aNBT.func_74767_n("gt.gasproof");
        }
        if (aNBT.func_74764_b("gt.acidproof")) {
            this.mAcidProof = aNBT.func_74767_n("gt.acidproof");
        }
        if (aNBT.func_74764_b("gt.magicproof")) {
            this.mMagicProof = aNBT.func_74767_n("gt.magicproof");
        }
        if (aNBT.func_74764_b("gt.liquidproof")) {
            this.mLiquidProof = aNBT.func_74767_n("gt.liquidproof");
        }
        if (aNBT.func_74764_b("gt.plasmaproof")) {
            this.mPlasmaProof = aNBT.func_74767_n("gt.plasmaproof");
        }
        this.mTemperatureMax = aNBT.func_74764_b("gt.temperature") ? aNBT.func_74763_f("gt.temperature") : this.mMaterial.mMeltingPoint - 50L;
        if (aNBT.func_74764_b("gt.tankcap")) {
            this.mTank.setCapacity(aNBT.func_74763_f("gt.tankcap"));
        }
        this.mTank.readFromNBT(aNBT, "gt.tank");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        this.mTank.writeToNBT(aNBT, "gt.tank");
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        this.mTank.writeToNBT(aNBT, "gt.tank");
        if (this.isClientSide() && !this.mTank.isEmpty()) {
            aNBT.func_74782_a("display", (NBTBase)UT.NBT.makeString(aNBT.func_74775_l("display"), "Name", FL.name(this.mTank, true)));
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + this.mTank.contentcap());
        if (this.mTank.has(250L) && this.isDrinkable()) {
            FoodStatFluid.INSTANCE.addAdditionalToolTips(aStack.func_77973_b(), aList, aStack, aF3_H);
            if (aStack.field_77994_a != 1) {
                aList.add(LH.Chat.RED + LH.get("gt.lang.requirement.unstacked"));
            }
        }
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.heat") + LH.Chat.WHITE + this.mTemperatureMax + LH.Chat.RED + " K");
        if (this.mLiquidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.liquid"));
        }
        if (this.mGasProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.gas"));
        }
        if (this.mAcidProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.acid"));
        }
        if (this.mPlasmaProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.plasma"));
        }
        if (this.mMagicProof) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.proof.magic"));
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.canFillWithRain() && CS.SERVER_TIME % 600L == 10L && this.field_145850_b.func_72896_J() && this.getRainOffset(0, 1, 0)) {
            Block tInFront;
            BiomeGenBase tBiome = this.getBiome();
            if (tBiome.field_76751_G > 0.0f && (double)tBiome.field_76750_F >= 0.2 && !WD.liquid(tInFront = this.getBlockAtSide((byte)1)) && !tInFront.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, CS.FORGE_DIR_OPPOSITES[1]) && !tInFront.isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, CS.FORGE_DIR[1])) {
                this.mTank.fill(FL.Water.make((long)Math.max(1.0f, tBiome.field_76751_G * 100.0f) * (long)(this.field_145850_b.func_72911_I() ? 2 : 1)), true);
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("plunger")) {
            return CS.GarbageGT.trash(this.mTank, 1000L);
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(this.mTank.contentcap());
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return true;
        }
        ItemStack aStack = aPlayer.func_71045_bC();
        ItemStack tStack = ST.container(ST.amount(1L, aStack), true);
        FluidStack tFluid = FL.getFluid(ST.amount(1L, aStack), true);
        if (aStack != null && this.isFluidAllowed(tFluid) && this.mTank.fillAll(tFluid)) {
            --aStack.field_77994_a;
            ST.give((Entity)aPlayer, tStack, true);
            return true;
        }
        if (aStack != null && (tStack = FL.fill(this.mTank, ST.amount(1L, aStack), true, true, true, true)) != null) {
            --aStack.field_77994_a;
            ST.give((Entity)aPlayer, tStack, true);
            return true;
        }
        if (this.isDrinkable() && this.canDrinkFromSide(aSide)) {
            aStack = this.toStack();
            if (aStack == null) {
                return true;
            }
            if (UT.Entities.isCreative(aPlayer) || aPlayer.func_71024_bL().func_75121_c() || FoodStatFluid.INSTANCE.alwaysEdible(aStack.func_77973_b(), aStack, aPlayer)) {
                switch (FoodStatFluid.INSTANCE.getFoodAction(aStack.func_77973_b(), aStack)) {
                    case eat: {
                        UT.Sounds.send("random.eat", this, false);
                        break;
                    }
                    default: {
                        UT.Sounds.send("random.drink", this, false);
                    }
                }
                this.mTank.remove(250L);
                aStack.func_77973_b().func_77654_b(aStack, this.field_145850_b, aPlayer);
            }
        }
        return true;
    }

    @Override
    public boolean onlyPlaceableWhenSneaking() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    public FluidStack getFluid(ItemStack aStack) {
        return this.mTank.getFluid();
    }

    public int getCapacity(ItemStack aStack) {
        return this.mTank.getCapacity();
    }

    public int fill(ItemStack aStack, FluidStack aFluid, boolean aDoFill) {
        if (!this.isFluidAllowed(aFluid) || aStack.field_77994_a != 1) {
            return 0;
        }
        int tFilled = this.mTank.fill(aFluid, aDoFill);
        if (tFilled > 0 && aDoFill) {
            UT.NBT.set(aStack, this.writeItemNBT(aStack.func_77942_o() ? aStack.func_77978_p() : UT.NBT.make()));
        }
        return tFilled;
    }

    public FluidStack drain(ItemStack aStack, int aMaxDrain, boolean aDoDrain) {
        if (aStack.field_77994_a != 1) {
            return CS.NF;
        }
        FluidStack tDrained = this.mTank.drain(aMaxDrain, aDoDrain);
        if (tDrained != CS.NF && aDoDrain) {
            UT.NBT.set(aStack, this.writeItemNBT(aStack.func_77942_o() ? aStack.func_77978_p() : UT.NBT.make()));
        }
        return tDrained;
    }

    @Override
    public boolean onItemUseFirst(MultiTileEntityItemInternal aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        FluidStack mFluid;
        if (aWorld.field_72995_K || aPlayer == null || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack) || aStack.field_77994_a != 1) {
            return false;
        }
        if (this.canWaterCrops() && FL.water(mFluid = aItem.getFluid(aStack))) {
            Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
            int aMeta = aWorld.func_72805_g(aX, aY, aZ);
            if (aBlock instanceof BlockCauldron) {
                if (aMeta >= 3 || mFluid.amount < 334) {
                    return false;
                }
                if (mFluid.amount >= 1000 && aMeta <= 0) {
                    aItem.drain(aStack, 1000, true);
                    WD.set(aWorld, aX, aY, aZ, aBlock, (long)(aMeta + 3), 3L);
                } else if (mFluid.amount >= 667 && aMeta <= 1) {
                    aItem.drain(aStack, 667, true);
                    WD.set(aWorld, aX, aY, aZ, aBlock, (long)(aMeta + 2), 3L);
                } else if (aMeta <= 2) {
                    aItem.drain(aStack, 334, true);
                    WD.set(aWorld, aX, aY, aZ, aBlock, (long)(aMeta + 1), 3L);
                }
                UT.Sounds.send("liquid.water", this.field_145850_b, this.getCoords());
                return true;
            }
            if (IL.GrC_Paddy.exists() && mFluid.amount >= 10) {
                if (IL.GrC_Paddy.block() == aBlock) {
                    int tIncrement = Math.min(7 - aMeta, mFluid.amount / 10);
                    if (tIncrement > 0) {
                        aItem.drain(aStack, tIncrement * 10, true);
                        aWorld.func_72921_c(aX, aY, aZ, aMeta + tIncrement, 3);
                        UT.Sounds.send("liquid.water", aWorld, aX, aY, aZ);
                    }
                    return true;
                }
                if (IL.GrC_Paddy.block() == aWorld.func_147439_a(aX, aY - 1, aZ)) {
                    int tMeta = aWorld.func_72805_g(aX, aY - 1, aZ);
                    int tIncrement = Math.min(7 - tMeta, mFluid.amount / 10);
                    if (tIncrement > 0) {
                        aItem.drain(aStack, tIncrement * 10, true);
                        aWorld.func_72921_c(aX, aY - 1, aZ, tMeta + tIncrement, 3);
                        UT.Sounds.send("liquid.water", aWorld, aX, aY - 1, aZ);
                    }
                    return true;
                }
            }
            TileEntity tTileEntity = WD.te(aWorld, aX, aY, aZ, false);
            try {
                if (tTileEntity instanceof ICropTile) {
                    int tHydration = ((ICropTile)tTileEntity).getHydrationStorage();
                    int tDrained = Math.min((200 - tHydration) / 10, mFluid.amount);
                    if (tDrained > 0) {
                        aItem.drain(aStack, tDrained, true);
                        ((ICropTile)tTileEntity).setHydrationStorage(tHydration + tDrained * 10);
                        UT.Sounds.send("liquid.water", aWorld, aX, aY, aZ);
                    }
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (tTileEntity instanceof TileCrucible) {
                    if (FL.water(mFluid) && FL.nonzero(aItem.drain(aStack, (int)FL.fill((IFluidHandler)tTileEntity, (byte)1, FL.Water.make(mFluid.amount), true), true))) {
                        UT.Sounds.send("liquid.water", aWorld, aX, aY, aZ);
                    }
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public ItemStack onItemRightClick(MultiTileEntityItemInternal aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        MovingObjectPosition tTarget;
        if (this.canPickUpFluids() && aStack.field_77994_a == 1 && (tTarget = WD.getMOP(aWorld, aPlayer, true)) != null && tTarget.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && aWorld.func_72962_a(aPlayer, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d)) {
            Block tBlock = aWorld.func_147439_a(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d);
            if (tBlock == Blocks.field_150355_j || tBlock == Blocks.field_150358_i) {
                if (aWorld.func_72805_g(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d) == 0) {
                    if (WD.infiniteWater(aWorld, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d)) {
                        aItem.fill(aStack, FL.Water.make(1000L), true);
                    } else if (aItem.fill(aStack, FL.Water.make(1000L), false) == 1000) {
                        aWorld.func_147468_f(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d);
                        aItem.fill(aStack, FL.Water.make(1000L), true);
                    }
                }
                return aStack;
            }
            if (tBlock == Blocks.field_150353_l || tBlock == Blocks.field_150356_k) {
                if (aWorld.func_72805_g(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d) == 0 && aItem.fill(aStack, FL.Lava.make(1000L), false) == 1000) {
                    aWorld.func_147468_f(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d);
                    aItem.fill(aStack, FL.Lava.make(1000L), true);
                }
                return aStack;
            }
            if (tBlock == CS.BlocksGT.River || WD.waterstream(tBlock)) {
                aItem.fill(aStack, FL.Water.make(1000L), true);
                return aStack;
            }
            if (tBlock == CS.BlocksGT.Ocean) {
                aItem.fill(aStack, FL.Ocean.make(1000L), true);
                return aStack;
            }
            if (tBlock == CS.BlocksGT.Swamp) {
                aItem.fill(aStack, FL.Dirty_Water.make(1000L), true);
                return aStack;
            }
            if (tBlock instanceof IFluidBlock) {
                FluidStack tDrained = ((IFluidBlock)tBlock).drain(aWorld, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d, false);
                if (tDrained != null && tDrained.amount > 0 && aItem.fill(aStack, tDrained, false) == tDrained.amount) {
                    aItem.fill(aStack, tDrained, true);
                    ((IFluidBlock)tBlock).drain(aWorld, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d, true);
                }
                return aStack;
            }
            tTarget.field_72311_b += CS.OFFX[tTarget.field_72310_e];
            tTarget.field_72312_c += CS.OFFY[tTarget.field_72310_e];
            tTarget.field_72309_d += CS.OFFZ[tTarget.field_72310_e];
            tBlock = aWorld.func_147439_a(tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d);
            if (tBlock instanceof IFluidBlock) {
                FluidStack tDrained = ((IFluidBlock)tBlock).drain(aWorld, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d, false);
                if (tDrained != null && tDrained.amount > 0 && aItem.fill(aStack, tDrained, false) == tDrained.amount) {
                    aItem.fill(aStack, tDrained, true);
                    ((IFluidBlock)tBlock).drain(aWorld, tTarget.field_72311_b, tTarget.field_72312_c, tTarget.field_72309_d, true);
                }
                return aStack;
            }
        }
        if (this.isDrinkable() && aStack.field_77994_a == 1 && (UT.Entities.isCreative(aPlayer) || aPlayer.func_71024_bL().func_75121_c() || FoodStatFluid.INSTANCE.alwaysEdible(aStack.func_77973_b(), aStack, aPlayer))) {
            aPlayer.func_71008_a(aStack, Math.max(FoodStatFluid.INSTANCE.getFoodLevel(aStack.func_77973_b(), aStack, null) * 8, 32));
            return aStack;
        }
        return aStack;
    }

    public int getMaxItemUseDuration(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        return this.isDrinkable() && aStack.field_77994_a == 1 ? Math.max(FoodStatFluid.INSTANCE.getFoodLevel(aStack.func_77973_b(), aStack, null) * 8, 32) : 0;
    }

    public EnumAction getItemUseAction(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        return this.isDrinkable() && aStack.field_77994_a == 1 ? FoodStatFluid.INSTANCE.getFoodAction(aStack.func_77973_b(), aStack) : EnumAction.none;
    }

    public ItemStack onEaten(MultiTileEntityItemInternal aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (!this.isDrinkable() || aStack.field_77994_a != 1) {
            return aStack;
        }
        int tFoodLevel = FoodStatFluid.INSTANCE.getFoodLevel(aStack.func_77973_b(), aStack, aPlayer);
        if (tFoodLevel > 0) {
            if (FoodStatFluid.INSTANCE.useAppleCoreFunctionality(aStack.func_77973_b(), aStack, aPlayer)) {
                aPlayer.func_71024_bL().func_151686_a((ItemFood)UT.Reflection.callConstructor("squeek.applecore.api.food.ItemFoodProxy", 0, null, true, aStack.func_77973_b()), aStack);
            } else {
                aPlayer.func_71024_bL().func_75122_a(tFoodLevel, FoodStatFluid.INSTANCE.getSaturation(aStack.func_77973_b(), aStack, aPlayer));
            }
        }
        if (!aWorld.field_72995_K && MD.ENVM.mLoaded) {
            try {
                float tTemperature = FoodStatFluid.INSTANCE.getTemperature(aStack.func_77973_b(), aStack, aPlayer) - 273.0f;
                float tHydration = FoodStatFluid.INSTANCE.getHydration(aStack.func_77973_b(), aStack, aPlayer);
                EnviroDataTracker tTracker = EM_StatusManager.lookupTracker((EntityLivingBase)aPlayer);
                if (tTracker != null && tTracker.bodyTemp >= 0.0f) {
                    tTracker.bodyTemp += (tTemperature - tTracker.bodyTemp) * FoodStatFluid.INSTANCE.getTemperatureEffect(aStack.func_77973_b(), aStack, aPlayer);
                    if (tHydration > 0.0f) {
                        tTracker.hydrate(tHydration);
                    } else if (tHydration < 0.0f) {
                        tTracker.dehydrate(-tHydration);
                    }
                }
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        FoodStatFluid.INSTANCE.onEaten(aStack.func_77973_b(), aStack, aPlayer, false, true);
        this.mTank.remove(250L);
        UT.NBT.set(aStack, this.writeItemNBT(aStack.func_77942_o() ? aStack.func_77978_p() : UT.NBT.make()));
        return aStack;
    }

    public FoodValues getFoodValues(MultiTileEntityItemInternal aItem, ItemStack aStack) {
        int tFoodLevel = FoodStatFluid.INSTANCE.getFoodLevel(aStack.func_77973_b(), aStack, null);
        return tFoodLevel > 0 && this.isDrinkable() ? new FoodValues(tFoodLevel, FoodStatFluid.INSTANCE.getSaturation(aStack.func_77973_b(), aStack, null)) : null;
    }

    @Override
    public int addFluidToConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
        if (aFluid == CS.NF || !this.isFluidAllowed(aFluid) || this.mTank.isEmpty() && aOnlyAddIfItAlreadyHasFluidsOfThatTypeOrIsDedicated) {
            return 0;
        }
        return this.mTank.fill(aFluid, true);
    }

    @Override
    public int removeFluidFromConnectedTank(byte aSide, FluidStack aFluid, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if (this.mTank.contains(aFluid) && this.mTank.has(aOnlyRemoveIfItCanRemoveAllAtOnce ? (long)aFluid.amount : 1L)) {
            return (int)this.mTank.remove(aFluid.amount);
        }
        return 0;
    }

    @Override
    public long getAmountOfFluidInConnectedTank(byte aSide, FluidStack aFluid) {
        return this.mTank.contains(aFluid) ? this.mTank.amount() : 0L;
    }

    public int tapFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return CS.SIDES_TOP[aSide] && this.isFluidAllowed(aFluid) ? this.mTank.fill(aFluid, aDoFill) : 0;
    }

    @Override
    public int funnelFill(byte aSide, FluidStack aFluid, boolean aDoFill) {
        return CS.SIDES_TOP[aSide] && this.isFluidAllowed(aFluid) ? this.mTank.fill(aFluid, aDoFill) : 0;
    }

    public boolean isDrinkable() {
        return this instanceof IMultiTileEntity.IMTE_GetFoodValues && this.mTank.has(250L) && CS.DrinksGT.REGISTER.containsKey(this.mTank.name());
    }

    public boolean isFluidAllowed(FluidStack aFluid) {
        return !(aFluid == null || FL.powerconducting(aFluid) || !(FL.gas(aFluid) ? this.mGasProof : this.mLiquidProof) || !this.mAcidProof && FL.acid(aFluid) || !this.mPlasmaProof && FL.plasma(aFluid) || !this.mMagicProof && FL.magic(aFluid) || FL.temperature(aFluid) > this.mTemperatureMax);
    }

    @Override
    public byte getMaxStackSize(ItemStack aStack, byte aDefault) {
        return this.mTank.has() ? (byte)1 : aDefault;
    }

    public boolean canWaterCrops() {
        return false;
    }

    public boolean canPickUpFluids() {
        return false;
    }

    public boolean canFillWithRain() {
        return false;
    }

    public boolean canDrinkFromSide(byte aSide) {
        return false;
    }
}

