/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.base;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.tileentity.base.TileEntityBase04MultiTileEntities;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.Explosion;

public abstract class TileEntityBase05Inventories
extends TileEntityBase04MultiTileEntities
implements IInventory,
ITileEntityInventoryGUI,
IMultiTileEntity.IMTE_OnBlockExploded,
IMultiTileEntity.IMTE_BreakBlock {
    private ItemStack[] mInventory = CS.ZL_IS;
    public boolean mInventoryChanged = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        this.mInventory = this.getDefaultInventory(aNBT);
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = aNBT.func_150295_c("gt.invlist", 10);
            for (int i = 0; i < tList.func_74745_c(); ++i) {
                NBTTagCompound tNBT = tList.func_150305_b(i);
                short tSlot = tNBT.func_74765_d("s");
                if (tSlot < 0 || tSlot >= this.mInventory.length) continue;
                this.mInventory[tSlot] = ST.load(tNBT, this.getDefaultStack(tSlot));
            }
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = new NBTTagList();
            for (short tSlot = 0; tSlot < this.mInventory.length; tSlot = (short)((short)(tSlot + 1))) {
                if (!ST.valid(this.mInventory[tSlot]) || !this.canSave(tSlot)) continue;
                tList.func_74742_a((NBTBase)UT.NBT.makeShort(ST.save(this.mInventory[tSlot]), "s", tSlot));
            }
            if (tList.func_74745_c() > 0) {
                aNBT.func_74782_a("gt.invlist", (NBTBase)tList);
            }
        }
    }

    @Override
    public NBTTagCompound writeItemNBT(NBTTagCompound aNBT) {
        aNBT = super.writeItemNBT(aNBT);
        if (this.mInventory != null && this.mInventory.length > 0) {
            NBTTagList tList = new NBTTagList();
            for (short tSlot = 0; tSlot < this.mInventory.length; tSlot = (short)((short)(tSlot + 1))) {
                if (!ST.valid(this.mInventory[tSlot]) || !this.keepSlot(tSlot)) continue;
                tList.func_74742_a((NBTBase)UT.NBT.makeShort(ST.save(this.mInventory[tSlot]), "s", tSlot));
            }
            if (tList.func_74745_c() > 0) {
                aNBT.func_74782_a("gt.invlist", (NBTBase)tList);
            }
        }
        return aNBT;
    }

    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        int tSize = Math.max(this.getMinimumInventorySize(), aNBT.func_74765_d("gt.invsize"));
        return tSize > 0 ? new ItemStack[tSize] : CS.ZL_IS;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.mInventoryChanged = false;
    }

    @Override
    public final ItemStack slot(int aIndex, ItemStack aStack) {
        this.mInventory[aIndex] = aStack;
        return this.mInventory[aIndex];
    }

    @Override
    public final ItemStack slot(int aIndex) {
        return this.mInventory[aIndex];
    }

    @Override
    public final ItemStack slotTake(int aIndex) {
        ItemStack rStack = this.mInventory[aIndex];
        this.mInventory[aIndex] = null;
        return rStack;
    }

    @Override
    public final boolean slotTrash(int aIndex) {
        return CS.GarbageGT.trash(this.slotTake(aIndex)) > 0;
    }

    @Override
    public final boolean slotNull(int aIndex) {
        if (this.mInventory[aIndex] != null && this.mInventory[aIndex].field_77994_a <= 0) {
            return this.slotKill(aIndex);
        }
        return false;
    }

    @Override
    public final boolean slotKill(int aIndex) {
        this.mInventory[aIndex] = null;
        return true;
    }

    @Override
    public final boolean slotHas(int aIndex) {
        return this.mInventory[aIndex] != null;
    }

    @Override
    public final boolean invempty() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int invsize() {
        return this.mInventory.length;
    }

    @Override
    public final NBTTagCompound slotNBT(int aIndex) {
        return this.mInventory[aIndex] != null ? this.mInventory[aIndex].func_77978_p() : null;
    }

    @Override
    public void updateTanks() {
        this.mInventoryChanged = true;
    }

    @Override
    public void updateInventory() {
        this.mInventoryChanged = true;
    }

    public boolean func_70300_a(EntityPlayer aPlayer) {
        return !this.isDead() && this.allowInteraction((Entity)aPlayer) && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.updateInventory();
    }

    public ItemStack func_70298_a(int aSlot, int aDecrement) {
        this.updateInventory();
        if (this.mInventory[aSlot] == null || aDecrement <= 0) {
            return CS.NI;
        }
        if (this.mInventory[aSlot].field_77994_a <= aDecrement) {
            ItemStack tStack = ST.copy(this.mInventory[aSlot]);
            if (this.allowZeroStacks(aSlot)) {
                this.mInventory[aSlot].field_77994_a = 0;
            } else {
                this.mInventory[aSlot] = CS.NI;
            }
            return tStack;
        }
        ItemStack rStack = this.mInventory[aSlot].func_77979_a(aDecrement);
        if (this.mInventory[aSlot].field_77994_a <= 0 && !this.allowZeroStacks(aSlot)) {
            this.mInventory[aSlot] = CS.NI;
        }
        return rStack;
    }

    public ItemStack func_70304_b(int aSlot) {
        ItemStack rStack = this.mInventory[aSlot];
        this.mInventory[aSlot] = null;
        return rStack;
    }

    public ItemStack func_70301_a(int aSlot) {
        return this.mInventory[aSlot];
    }

    public String func_145825_b() {
        String rName = this.getCustomName();
        if (UT.Code.stringValid(rName)) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    public int func_70302_i_() {
        return this.mInventory == null ? 0 : this.mInventory.length;
    }

    public void func_70299_a(int aSlot, ItemStack aStack) {
        this.updateInventory();
        this.mInventory[aSlot] = OM.get(aStack);
    }

    public boolean func_145818_k_() {
        return this.getCustomName() != null;
    }

    public boolean func_94041_b(int aSlot, ItemStack aStack) {
        return true;
    }

    public int getMinimumInventorySize() {
        return 0;
    }

    public boolean allowZeroStacks(int aSlot) {
        return false;
    }

    public ItemStack[] getInventory() {
        return this.mInventory;
    }

    public void setInventory(ItemStack[] aInventory) {
        this.mInventory = aInventory;
    }

    public void removeAllDroppableNullStacks() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (!this.canDrop(i) || this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = CS.NI;
        }
    }

    public abstract boolean canDrop(int var1);

    public boolean keepSlot(int aSlot) {
        return false;
    }

    public boolean breakDrop(int aSlot) {
        return true;
    }

    public boolean canSave(int aSlot) {
        return true;
    }

    public ItemStack getDefaultStack(int aSlot) {
        return null;
    }

    @Override
    public int getSizeInventoryGUI() {
        return this.mInventory == null ? 0 : this.mInventory.length;
    }

    @Override
    public ItemStack getStackInSlotGUI(int aSlot) {
        return this.mInventory[aSlot];
    }

    @Override
    public ItemStack decrStackSizeGUI(int aSlot, int aDecrement) {
        this.updateInventory();
        if (this.mInventory[aSlot] == null || aDecrement <= 0) {
            return CS.NI;
        }
        if (this.mInventory[aSlot].field_77994_a <= aDecrement) {
            ItemStack tStack = ST.copy(this.mInventory[aSlot]);
            if (this.allowZeroStacks(aSlot)) {
                this.mInventory[aSlot].field_77994_a = 0;
            } else {
                this.mInventory[aSlot] = CS.NI;
            }
            return tStack;
        }
        ItemStack rStack = this.mInventory[aSlot].func_77979_a(aDecrement);
        if (this.mInventory[aSlot].field_77994_a <= 0 && !this.allowZeroStacks(aSlot)) {
            this.mInventory[aSlot] = CS.NI;
        }
        return rStack;
    }

    @Override
    public ItemStack getStackInSlotOnClosingGUI(int aSlot) {
        ItemStack rStack = this.mInventory[aSlot];
        this.mInventory[aSlot] = null;
        return rStack;
    }

    @Override
    public void setInventorySlotContentsGUI(int aSlot, ItemStack aStack) {
        this.updateInventory();
        this.mInventory[aSlot] = OM.get(aStack);
    }

    @Override
    public String getInventoryNameGUI() {
        String rName = this.getCustomName();
        if (UT.Code.stringValid(rName)) {
            return rName;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        return tRegistry == null ? this.getClass().getName() : tRegistry.getLocal(this.getMultiTileEntityID());
    }

    @Override
    public boolean hasCustomInventoryNameGUI() {
        return this.getCustomName() != null;
    }

    @Override
    public int getInventoryStackLimitGUI(int aSlot) {
        return this.func_70297_j_();
    }

    @Override
    public void markDirtyGUI() {
        this.func_70296_d();
    }

    @Override
    public boolean isUseableByPlayerGUI(EntityPlayer aPlayer) {
        return !this.isDead() && this.allowInteraction((Entity)aPlayer) && aPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void openInventoryGUI() {
        this.func_70295_k_();
    }

    @Override
    public void closeInventoryGUI() {
        this.func_70305_f();
    }

    @Override
    public boolean isItemValidForSlotGUI(int aSlot, ItemStack aStack) {
        return this.func_94041_b(aSlot, aStack);
    }

    @Override
    public boolean canTakeOutOfSlotGUI(int aSlot) {
        return true;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (CS.RNGSUS.nextInt(3) == 0) continue;
            CS.GarbageGT.trash(this.mInventory, i);
        }
        this.setToAir();
    }

    @Override
    public boolean breakBlock() {
        if (this.isServerSide()) {
            for (int i = 0; i < this.mInventory.length; i = (int)((short)(i + 1))) {
                if (this.mInventory[i] == null || !this.canDrop(i) || ST.debug(this.mInventory[i]) || !this.breakDrop(i)) continue;
                ItemStack tDumpedStack = ST.amount(UT.Code.bind_(0L, 512L * (long)Math.max(1, this.mInventory[i].func_77976_d()), this.mInventory[i].field_77994_a), this.mInventory[i]);
                int tMaxSize = Math.max(1, this.mInventory[i].func_77976_d());
                while (tDumpedStack.field_77994_a > tMaxSize) {
                    ST.drop(this.field_145850_b, this.getCoords(), ST.amount(tMaxSize, tDumpedStack));
                    tDumpedStack.field_77994_a -= tMaxSize;
                    this.mInventory[i].field_77994_a -= tMaxSize;
                }
                if (tDumpedStack.field_77994_a > 0) {
                    this.mInventory[i].field_77994_a -= tDumpedStack.field_77994_a;
                    ST.drop(this.field_145850_b, this.getCoords(), ST.copy(tDumpedStack));
                }
                CS.GarbageGT.trash(this.mInventory, i);
            }
        }
        return false;
    }

    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (ST.invalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (ST.invalid(tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (ST.equal(tStack, aStack = OM.get_(aStack)) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(Math.max(1, tStack.func_77976_d()), this.func_70297_j_())) {
            tStack.field_77994_a += aStack.field_77994_a;
            this.updateInventory();
            return true;
        }
        return false;
    }
}

