/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.data.CS;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;

public class BlockTextureSided
implements ITexture {
    private final IIconContainer[] mIconContainers;
    public short[] mRGBa;
    private final boolean mAllowAlpha;
    private final boolean mUseMaxBrightness;

    public static BlockTextureSided get(IIconContainer aIcon0, IIconContainer aIcon1, IIconContainer aIcon2, IIconContainer aIcon3, IIconContainer aIcon4, IIconContainer aIcon5, short[] aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureSided(aIcon0, aIcon1, aIcon2, aIcon3, aIcon4, aIcon5, aRGBa, aAllowAlpha, aUseMaxBrightness) : null;
    }

    public static BlockTextureSided get(IIconContainer aBottom, IIconContainer aTop, IIconContainer aSides, short[] aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness) {
        return CS.CODE_CLIENT || CS.CODE_UNCHECKED ? new BlockTextureSided(aBottom, aTop, aSides, aRGBa, aAllowAlpha, aUseMaxBrightness) : null;
    }

    public BlockTextureSided(IIconContainer aIcon0, IIconContainer aIcon1, IIconContainer aIcon2, IIconContainer aIcon3, IIconContainer aIcon4, IIconContainer aIcon5, short[] aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ BlockTextureSided");
        }
        this.mIconContainers = new IIconContainer[]{aIcon0, aIcon1, aIcon2, aIcon3, aIcon4, aIcon5};
        this.mUseMaxBrightness = aUseMaxBrightness;
        this.mAllowAlpha = aAllowAlpha;
        this.mRGBa = aRGBa;
    }

    public BlockTextureSided(IIconContainer aBottom, IIconContainer aTop, IIconContainer aSides, short[] aRGBa, boolean aAllowAlpha, boolean aUseMaxBrightness) {
        this(aBottom, aTop, aSides, aSides, aSides, aSides, aRGBa, aAllowAlpha, aUseMaxBrightness);
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int aSide = 5;
        int j = this.mIconContainers[5].getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderZPos(this.mIconContainers[5].getIcon(0), this.mIconContainers[5].isUsingColorModulation(i) ? this.mRGBa : this.mIconContainers[5].getIconColor(i), this.mAllowAlpha, this.mUseMaxBrightness, true, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int aSide = 4;
        int j = this.mIconContainers[4].getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderZPos(this.mIconContainers[4].getIcon(0), this.mIconContainers[4].isUsingColorModulation(i) ? this.mRGBa : this.mIconContainers[4].getIconColor(i), this.mAllowAlpha, this.mUseMaxBrightness, true, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        boolean aSide = true;
        int j = this.mIconContainers[1].getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderZPos(this.mIconContainers[1].getIcon(0), this.mIconContainers[1].isUsingColorModulation(i) ? this.mRGBa : this.mIconContainers[1].getIconColor(i), this.mAllowAlpha, this.mUseMaxBrightness, true, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        boolean aSide = false;
        int j = this.mIconContainers[0].getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderZPos(this.mIconContainers[0].getIcon(0), this.mIconContainers[0].isUsingColorModulation(i) ? this.mRGBa : this.mIconContainers[0].getIconColor(i), this.mAllowAlpha, this.mUseMaxBrightness, true, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int aSide = 3;
        int j = this.mIconContainers[3].getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderZPos(this.mIconContainers[3].getIcon(0), this.mIconContainers[3].isUsingColorModulation(i) ? this.mRGBa : this.mIconContainers[3].getIconColor(i), this.mAllowAlpha, this.mUseMaxBrightness, true, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
        int aSide = 2;
        int j = this.mIconContainers[2].getIconPasses();
        for (int i = 0; i < j; ++i) {
            ITexture.Util.renderZPos(this.mIconContainers[2].getIcon(0), this.mIconContainers[2].isUsingColorModulation(i) ? this.mRGBa : this.mIconContainers[2].getIconColor(i), this.mAllowAlpha, this.mUseMaxBrightness, true, aRenderer, aBlock, aX, aY, aZ, this.mUseMaxBrightness ? 240 : aBrightness, aChangedBlockBounds);
        }
    }

    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainers != null && this.mIconContainers[0] != null && this.mIconContainers[1] != null && this.mIconContainers[2] != null && this.mIconContainers[3] != null && this.mIconContainers[4] != null && this.mIconContainers[5] != null;
    }
}

