/*
 * Decompiled with CFR 0.152.
 */
package gregapi.data;

import java.util.List;

public class TC {
    public static final TC ORDO = new TC("Ordo");
    public static final TC PERDITIO = new TC("Perditio");
    public static final TC TERRA = new TC("Terra");
    public static final TC AQUA = new TC("Aqua");
    public static final TC AER = new TC("Aer");
    public static final TC IGNIS = new TC("Ignis");
    public static final TC LUX = new TC(AER, IGNIS, "Lux");
    public static final TC TEMPESTAS = new TC(AER, AQUA, "Tempestas");
    public static final TC MOTUS = new TC(AER, ORDO, "Motus");
    public static final TC VACUOS = new TC(AER, PERDITIO, "Vacuos");
    public static final TC GELUM = new TC(IGNIS, PERDITIO, "Gelum");
    public static final TC POTENTIA = new TC(IGNIS, ORDO, "Potentia");
    public static final TC VITREUS = new TC(TERRA, ORDO, "Vitreus");
    public static final TC VICTUS = new TC(AQUA, TERRA, "Victus");
    public static final TC VENEMUM = new TC(AQUA, PERDITIO, "Venemum");
    public static final TC PERMUTATIO = new TC(ORDO, PERDITIO, "Permutatio");
    public static final TC VOLATUS = new TC(MOTUS, AER, "Volatus");
    public static final TC VINCULUM = new TC(MOTUS, PERDITIO, "Vinculum");
    public static final TC ITER = new TC(MOTUS, TERRA, "Iter");
    public static final TC METALLUM = new TC(VITREUS, TERRA, "Metallum");
    public static final TC HERBA;
    public static final TC GRANUM;
    public static final TC LIMUS;
    public static final TC SANO;
    public static final TC MORTUUS;
    public static final TC BESTIA;
    public static final TC FAMES;
    public static final TC TENEBRAE;
    public static final TC PRAECANTIO;
    public static final TC REFLEXIO;
    public static final TC RADIO;
    public static final TC ARBOR;
    public static final TC AURAM;
    public static final TC VITIUM;
    public static final TC SPIRITUS;
    public static final TC EXAMINIS;
    public static final TC ALIENIS;
    public static final TC CORPUS;
    public static final TC MAGNETO;
    public static final TC SENSUS;
    public static final TC COGNITIO;
    public static final TC COGNITO;
    public static final TC STRONTIO;
    public static final TC HUMANUS;
    public static final TC PERFODIO;
    public static final TC INSTRUMENTUM;
    public static final TC MESSIS;
    public static final TC LUCRUM;
    public static final TC TELUM;
    public static final TC TUTAMEN;
    public static final TC PANNUS;
    public static final TC FABRICO;
    public static final TC METO;
    public static final TC MACHINA;
    public static final TC NEBRISUM;
    public static final TC ELECTRUM;
    @Deprecated
    public static final TC VENENUM;
    public String mName;
    public TC mComponentA;
    public TC mComponentB;
    public byte mTier;
    public Object mAspect;

    public TC(String aName) {
        this.mName = aName;
        this.mComponentA = this;
        this.mComponentB = this;
        this.mTier = 0;
    }

    public TC(TC aComponentA, TC aComponentB, String aName) {
        this.mName = aName;
        this.mComponentA = aComponentA;
        this.mComponentB = aComponentB;
        this.mTier = (byte)(1 + Math.max(this.mComponentA.mTier, this.mComponentB.mTier));
    }

    public static TC_AspectStack stack(TC aAspect, long aAmount) {
        return new TC_AspectStack(aAspect, aAmount);
    }

    public TC_AspectStack get(long aAmount) {
        return new TC_AspectStack(this, aAmount);
    }

    static {
        GRANUM = HERBA = new TC(VICTUS, TERRA, "Herba");
        LIMUS = new TC(VICTUS, AQUA, "Limus");
        SANO = new TC(VICTUS, ORDO, "Sano");
        MORTUUS = new TC(VICTUS, PERDITIO, "Mortuus");
        BESTIA = new TC(VICTUS, MOTUS, "Bestia");
        FAMES = new TC(VICTUS, VACUOS, "Fames");
        TENEBRAE = new TC(LUX, VACUOS, "Tenebrae");
        PRAECANTIO = new TC(POTENTIA, VACUOS, "Praecantio");
        REFLEXIO = new TC(POTENTIA, PERMUTATIO, "Reflexio");
        RADIO = new TC(POTENTIA, LUX, "Radio");
        ARBOR = new TC(HERBA, AER, "Arbor");
        AURAM = new TC(PRAECANTIO, AER, "Auram");
        VITIUM = new TC(PRAECANTIO, PERDITIO, "Vitium");
        SPIRITUS = new TC(MORTUUS, VICTUS, "Spiritus");
        EXAMINIS = new TC(MORTUUS, MOTUS, "Examinis");
        ALIENIS = new TC(TENEBRAE, VACUOS, "Alienis");
        CORPUS = new TC(BESTIA, MORTUUS, "Corpus");
        MAGNETO = new TC(ITER, METALLUM, "Magneto");
        SENSUS = new TC(SPIRITUS, AER, "Sensus");
        COGNITO = COGNITIO = new TC(SPIRITUS, IGNIS, "Cognitio");
        STRONTIO = new TC(COGNITIO, PERDITIO, "Strontio");
        HUMANUS = new TC(COGNITIO, BESTIA, "Humanus");
        PERFODIO = new TC(HUMANUS, TERRA, "Perfodio");
        INSTRUMENTUM = new TC(HUMANUS, ORDO, "Instrumentum");
        MESSIS = new TC(HUMANUS, HERBA, "Messis");
        LUCRUM = new TC(HUMANUS, FAMES, "Lucrum");
        TELUM = new TC(INSTRUMENTUM, IGNIS, "Telum");
        TUTAMEN = new TC(INSTRUMENTUM, TERRA, "Tutamen");
        PANNUS = new TC(INSTRUMENTUM, BESTIA, "Pannus");
        FABRICO = new TC(INSTRUMENTUM, HUMANUS, "Fabrico");
        METO = new TC(INSTRUMENTUM, MESSIS, "Meto");
        MACHINA = new TC(INSTRUMENTUM, MOTUS, "Machina");
        NEBRISUM = new TC(PERFODIO, LUCRUM, "Nebrisum");
        ELECTRUM = new TC(MACHINA, POTENTIA, "Electrum");
        VENENUM = VENEMUM;
    }

    public static class TC_AspectStack {
        public TC mAspect;
        public long mAmount;

        public TC_AspectStack(TC aAspect, long aAmount) {
            this.mAspect = aAspect;
            this.mAmount = aAmount;
        }

        public TC_AspectStack copy() {
            return new TC_AspectStack(this.mAspect, this.mAmount);
        }

        public TC_AspectStack copy(long aAmount) {
            return new TC_AspectStack(this.mAspect, aAmount);
        }

        public List<TC_AspectStack> addToAspectList(List<TC_AspectStack> aList) {
            if (this.mAmount <= 0L) {
                return aList;
            }
            for (TC_AspectStack tAspect : aList) {
                if (tAspect.mAspect != this.mAspect && (tAspect.mAspect.mAspect == null || tAspect.mAspect.mAspect != this.mAspect.mAspect)) continue;
                tAspect.mAmount += this.mAmount;
                return aList;
            }
            aList.add(this.copy());
            return aList;
        }

        public boolean removeFromAspectList(List<TC_AspectStack> aList) {
            for (TC_AspectStack tAspect : aList) {
                if (tAspect.mAspect != this.mAspect && (tAspect.mAspect.mAspect == null || tAspect.mAspect.mAspect != this.mAspect.mAspect) || tAspect.mAmount < this.mAmount) continue;
                tAspect.mAmount -= this.mAmount;
                if (tAspect.mAmount == 0L) {
                    aList.remove(tAspect);
                }
                return true;
            }
            return false;
        }
    }
}

