/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.cover.covers.AbstractCoverDefault;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;

public class CoverTextureMulti
extends AbstractCoverDefault {
    public final ITexture[] mTextures;
    public final boolean mHasCollide;
    public final boolean mBackground;
    public final String mSound;

    public CoverTextureMulti(boolean aHasCollide, boolean aBackground, String aSound, String aFolder, int aAmount) {
        this.mSound = aSound;
        this.mHasCollide = aHasCollide;
        this.mBackground = aBackground;
        this.mTextures = new ITexture[aAmount];
        for (int i = 0; i < this.mTextures.length; ++i) {
            this.mTextures[i] = BlockTextureDefault.get(aFolder + i);
        }
    }

    public CoverTextureMulti(boolean aHasCollide, boolean aBackground, String aSound, ITexture ... aTextures) {
        this.mSound = aSound;
        this.mHasCollide = aHasCollide;
        this.mBackground = aBackground;
        this.mTextures = aTextures;
    }

    public CoverTextureMulti(boolean aHasCollide, String aSound, String aFolder, int aAmount) {
        this.mSound = aSound;
        this.mHasCollide = aHasCollide;
        this.mBackground = true;
        this.mTextures = new ITexture[aAmount];
        for (int i = 0; i < this.mTextures.length; ++i) {
            this.mTextures[i] = BlockTextureDefault.get(aFolder + i);
        }
    }

    public CoverTextureMulti(boolean aHasCollide, String aSound, ITexture ... aTextures) {
        this.mSound = aSound;
        this.mHasCollide = aHasCollide;
        this.mBackground = true;
        this.mTextures = aTextures;
    }

    public CoverTextureMulti(String aFolder, String aSound, int aAmount) {
        this(true, aSound, aFolder, aAmount);
    }

    public CoverTextureMulti(String aSound, ITexture ... aTextures) {
        this(true, aSound, aTextures);
    }

    public CoverTextureMulti(boolean aHasCollide, boolean aBackground, String aFolder, int aAmount) {
        this(aHasCollide, aBackground, null, aFolder, aAmount);
    }

    public CoverTextureMulti(boolean aHasCollide, boolean aBackground, ITexture ... aTextures) {
        this(aHasCollide, aBackground, (String)null, aTextures);
    }

    public CoverTextureMulti(boolean aHasCollide, String aFolder, int aAmount) {
        this(aHasCollide, null, aFolder, aAmount);
    }

    public CoverTextureMulti(boolean aHasCollide, ITexture ... aTextures) {
        this(aHasCollide, (String)null, aTextures);
    }

    public CoverTextureMulti(String aFolder, int aAmount) {
        this(true, aFolder, aAmount);
    }

    public CoverTextureMulti(ITexture ... aTextures) {
        this(true, aTextures);
    }

    @Override
    public long onToolClick(byte aSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("chisel") && this.mTextures.length > 1) {
            aData.visual(aSide, (short)((aData.mVisuals[aSide] + 1) % this.mTextures.length));
            return 100L;
        }
        return 0L;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return this.mTextures[aData.mVisuals[aSide] % this.mTextures.length];
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return this.mBackground ? (aSide != aTextureSide ? BACKGROUND_COVER : BlockTextureMulti.get(BACKGROUND_COVER, this.getCoverTextureSurface(aSide, aData))) : this.getCoverTextureSurface(aSide, aData);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return this.mBackground ? BACKGROUND_COVER : this.getCoverTextureSurface(aSide, aData);
    }

    @Override
    public void onCoverPlaced(byte aCoverSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aPlayer != null) {
            UT.Sounds.send(this.mSound == null ? CS.SFX.GT_SCREWDRIVER : this.mSound, aData.mTileEntity);
        }
    }

    @Override
    public void onAfterCrowbar(ITileEntityCoverable aTileEntity) {
        UT.Sounds.send(this.mSound == null ? "random.break" : this.mSound, 1.0f, -1.0f, aTileEntity);
    }

    @Override
    public void getCollisions(byte aCoverSide, CoverData aData, AxisAlignedBB aAABB, List<AxisAlignedBB> aList, Entity aEntity) {
        if (this.mHasCollide) {
            super.getCollisions(aCoverSide, aData, aAABB, aList, aEntity);
        }
    }

    @Override
    public boolean isDecorative(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        if (this.mTextures.length > 1) {
            aList.add(LH.get("gt.lang.use.chisel.to.switch.design"));
        }
    }
}

