/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.ITileEntityConnector;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CoverShutter
extends AbstractCoverAttachment {
    public static final ITexture sTextureInverted = BlockTextureDefault.get("machines/covers/shutter/inverted");
    public static final ITexture sTextureNormal = BlockTextureDefault.get("machines/covers/shutter/normal");

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver")) {
            aData.visual(aCoverSide, (short)(aData.mVisuals[aCoverSide] == 0 ? 1 : 0));
            if (aChatReturn != null) {
                aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Normal Shutter" : "Inverted Shutter");
            }
            if (aData.mTileEntity instanceof ITileEntityConnector) {
                if (aData.mVisuals[aCoverSide] == 0 == aData.mStopped) {
                    ((ITileEntityConnector)((Object)aData.mTileEntity)).disconnect(aCoverSide, true);
                } else {
                    ((ITileEntityConnector)((Object)aData.mTileEntity)).connect(aCoverSide, true);
                }
            }
            return 1000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Normal Shutter" : "Inverted Shutter");
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onStoppedUpdate(byte aCoverSide, CoverData aData, boolean aStopped) {
        if (aData.mTileEntity instanceof ITileEntityConnector) {
            if (aData.mVisuals[aCoverSide] == 0 == aStopped) {
                ((ITileEntityConnector)((Object)aData.mTileEntity)).disconnect(aCoverSide, true);
            } else {
                ((ITileEntityConnector)((Object)aData.mTileEntity)).connect(aCoverSide, true);
            }
        }
    }

    @Override
    public boolean interceptItemInsert(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aData.mVisuals[aCoverSide] == 0 == aData.mStopped;
    }

    @Override
    public boolean interceptItemExtract(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        return aData.mVisuals[aCoverSide] == 0 == aData.mStopped;
    }

    @Override
    public boolean interceptFluidFill(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToFill) {
        return aData.mVisuals[aCoverSide] == 0 == aData.mStopped;
    }

    @Override
    public boolean interceptFluidDrain(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToDrain) {
        return aData.mVisuals[aCoverSide] == 0 == aData.mStopped;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return CS.ALONG_AXIS[aCoverSide][aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted) : BACKGROUND_COVER;
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }
}

