/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover;

import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.cover.CoverData;
import gregapi.cover.ICover;
import gregapi.cover.ITileEntityCoverable;
import gregapi.util.ST;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CoverRegistry {
    public static ItemStackMap<ItemStackContainer, ICover> COVERS = new ItemStackMap();

    public static ICover get(short aID, short aMetaData) {
        return COVERS.get(aID, (long)aMetaData);
    }

    public static ICover get(ItemStack aStack) {
        return aStack == null ? null : CoverRegistry.get(ST.id(aStack), ST.meta_(aStack));
    }

    public static void put(ItemStack aStack, ICover aCover) {
        if (ST.valid(aStack)) {
            COVERS.put(aStack, aCover);
        }
    }

    public static void put(Item aItem, long aMetaData, ICover aCover) {
        if (aItem != null) {
            COVERS.put(aItem, aMetaData, aCover);
        }
    }

    public static void put(Block aBlock, long aMetaData, ICover aCover) {
        if (aBlock != null) {
            COVERS.put(aBlock, aMetaData, aCover);
        }
    }

    public static CoverData coverdata(ITileEntityCoverable aTileEntity, NBTTagCompound aNBT) {
        return aNBT == null ? new CoverData(aTileEntity) : new CoverData(aTileEntity, aNBT);
    }

    @Deprecated
    public static void put(ItemStackContainer aStack, ICover aCover) {
        if (aStack != null && ST.valid(aStack.toStack())) {
            COVERS.put(aStack, aCover);
        }
    }
}

