/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import cpw.mods.fml.common.Loader;
import gregapi.code.ICondition;
import gregapi.code.ITagDataContainer;
import gregapi.util.ST;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public final class ModData
implements ICondition<ITagDataContainer<?>> {
    public static final Map<String, ModData> MODS = new HashMap<String, ModData>();
    public boolean mLoaded;
    public final String mID;
    public final String mName;
    public final String mPrefix;

    public ModData(String aID, String aName) {
        this.mID = aID;
        this.mName = aName;
        this.mPrefix = this.mID + ":";
        this.mLoaded = Loader.isModLoaded((String)this.mID);
        MODS.put(aID, this);
        MODS.put(aID.toLowerCase(), this);
        MODS.put(aID.toUpperCase(), this);
    }

    public ModData setLoaded(boolean aLoaded) {
        this.mLoaded = aLoaded;
        return this;
    }

    public boolean owns(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mLoaded && this.owns_(ST.regName(aWorld.func_147439_a(aX, aY, aZ)));
    }

    public boolean owns(Block aBlock) {
        return this.mLoaded && this.owns_(ST.regName(aBlock));
    }

    public boolean owns(Item aItem) {
        return this.mLoaded && this.owns_(ST.regName(aItem));
    }

    public boolean owns(ItemStack aStack) {
        return this.mLoaded && this.owns_(ST.regName(aStack));
    }

    public boolean owns(String aRegName) {
        return this.mLoaded && this.owns_(aRegName);
    }

    public boolean owns_(String aRegName) {
        return aRegName != null && aRegName.startsWith(this.mPrefix);
    }

    public boolean owns(IBlockAccess aWorld, int aX, int aY, int aZ, String aContains) {
        return this.mLoaded && this.owns_(ST.regName(aWorld.func_147439_a(aX, aY, aZ)), aContains);
    }

    public boolean owns(Block aBlock, String aContains) {
        return this.mLoaded && this.owns_(ST.regName(aBlock), aContains);
    }

    public boolean owns(Item aItem, String aContains) {
        return this.mLoaded && this.owns_(ST.regName(aItem), aContains);
    }

    public boolean owns(ItemStack aStack, String aContains) {
        return this.mLoaded && this.owns_(ST.regName(aStack), aContains);
    }

    public boolean owns(String aRegName, String aContains) {
        return this.mLoaded && this.owns_(aRegName, aContains);
    }

    public boolean owns_(String aRegName, String aContains) {
        return aRegName != null && aRegName.startsWith(this.mPrefix) && aRegName.contains(aContains);
    }

    public String toString() {
        return this.mID;
    }

    @Override
    public boolean isTrue(ITagDataContainer<?> aObject) {
        return this.mLoaded;
    }

    public boolean equals(Object aObject) {
        return aObject instanceof ModData && ((ModData)aObject).mID.equals(this.mID);
    }

    public int hashCode() {
        return this.mID.hashCode();
    }
}

