/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.misc;

import gregapi.block.BlockBaseSealable;
import gregapi.block.IBlockOnWalkOver;
import gregapi.block.IBlockToolable;
import gregapi.block.ToolCompat;
import gregapi.data.CS;
import gregapi.data.OP;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.ITexture;
import gregapi.render.RendererBlockTextured;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockBaseSpike
extends BlockBaseSealable
implements IBlockOnWalkOver,
IBlockToolable,
IRenderedBlock {
    public final OreDictMaterial mMat1;
    public final OreDictMaterial mMat2;
    public SpikeRendererBase[] mRenderers = new SpikeRendererBase[16];

    public BlockBaseSpike(String aNameInternal, OreDictMaterial aMat1, OreDictMaterial aMat2) {
        super(null, aNameInternal, Material.field_151573_f, Block.field_149777_j);
        this.func_149647_a(CreativeTabs.field_78028_d);
        this.mMat1 = aMat1;
        this.mMat2 = aMat2;
        CR.shaped(ST.make(this, 1L, 0L), CR.DEF_NCC, "BTB", "TPT", "BTB", 'B', OP.toolHeadSword.dat(this.mMat1), 'P', OP.plate.dat(this.mMat1), 'T', OP.screw.dat(this.mMat1));
        CR.shaped(ST.make(this, 1L, 6L), CR.DEF_NCC, "TBT", "BPB", "TBT", 'B', OP.toolHeadSword.dat(this.mMat1), 'P', OP.plate.dat(this.mMat1), 'T', OP.screw.dat(this.mMat1));
        CR.shaped(ST.make(this, 1L, 8L), CR.DEF_NCC, "BTB", "TPT", "BTB", 'B', OP.toolHeadSword.dat(this.mMat2), 'P', OP.plate.dat(this.mMat2), 'T', OP.screw.dat(this.mMat2));
        CR.shaped(ST.make(this, 1L, 14L), CR.DEF_NCC, "TBT", "BPB", "TBT", 'B', OP.toolHeadSword.dat(this.mMat2), 'P', OP.plate.dat(this.mMat2), 'T', OP.screw.dat(this.mMat2));
        CR.shapeless(ST.make(this, 1L, 7L), CR.DEF_NCC, new Object[]{ST.make(this, 1L, 6L)});
        CR.shapeless(ST.make(this, 1L, 15L), CR.DEF_NCC, new Object[]{ST.make(this, 1L, 14L)});
        CR.shapeless(ST.make(this, 1L, 6L), CR.DEF_NCC, new Object[]{ST.make(this, 1L, 7L)});
        CR.shapeless(ST.make(this, 1L, 14L), CR.DEF_NCC, new Object[]{ST.make(this, 1L, 15L)});
        OM.data(ST.make(this, 1L, 0L), aMat1, 5837832000L, new OreDictMaterialStack[0]);
        OM.data(ST.make(this, 1L, 6L), aMat1, 5837832000L, new OreDictMaterialStack[0]);
        OM.data(ST.make(this, 1L, 7L), aMat1, 5837832000L, new OreDictMaterialStack[0]);
        OM.data(ST.make(this, 1L, 8L), aMat2, 5837832000L, new OreDictMaterialStack[0]);
        OM.data(ST.make(this, 1L, 14L), aMat2, 5837832000L, new OreDictMaterialStack[0]);
        OM.data(ST.make(this, 1L, 15L), aMat2, 5837832000L, new OreDictMaterialStack[0]);
        if (CS.CODE_CLIENT) {
            this.mRenderers[0] = new SpikeRendererYNeg(aMat1);
            this.mRenderers[1] = new SpikeRendererYPos(aMat1);
            this.mRenderers[2] = new SpikeRendererZNeg(aMat1);
            this.mRenderers[3] = new SpikeRendererZPos(aMat1);
            this.mRenderers[4] = new SpikeRendererXNeg(aMat1);
            this.mRenderers[5] = new SpikeRendererXPos(aMat1);
            this.mRenderers[6] = this.mRenderers[7] = new SpikeRendererOmni(aMat1);
            this.mRenderers[8] = new SpikeRendererYNeg(aMat2);
            this.mRenderers[9] = new SpikeRendererYPos(aMat2);
            this.mRenderers[10] = new SpikeRendererZNeg(aMat2);
            this.mRenderers[11] = new SpikeRendererZPos(aMat2);
            this.mRenderers[12] = new SpikeRendererXNeg(aMat2);
            this.mRenderers[13] = new SpikeRendererXPos(aMat2);
            this.mRenderers[14] = this.mRenderers[15] = new SpikeRendererOmni(aMat2);
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("builder", ST.make(this, 1L, 32767L));
        }
    }

    @Override
    public void onWalkOver(EntityLivingBase aEntity, World aWorld, int aX, int aY, int aZ) {
        if ((WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) != 1) {
            aEntity.field_70159_w *= 0.1;
            aEntity.field_70179_y *= 0.1;
        }
    }

    public int func_149660_a(World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ, int aMeta) {
        return (aMeta & 7) < 6 ? aMeta & 8 | CS.OPOS[aSide] : aMeta;
    }

    @Override
    public void onBlockAdded2(World aWorld, int aX, int aY, int aZ) {
        if (this.useGravity(WD.meta((IBlockAccess)aWorld, aX, aY, aZ))) {
            UT.Sounds.send("random.anvil_land", 1.0f, 2.0f, aWorld, aX, aY, aZ);
        }
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "pickaxe";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return aMeta < 8 ? this.mMat1.mToolQuality : this.mMat2.mToolQuality;
    }

    @Override
    public int func_149717_k() {
        return 0;
    }

    @Override
    public int func_149692_a(int aMeta) {
        return (aMeta & 7) < 6 ? aMeta & 8 : aMeta;
    }

    @Override
    public byte maxMeta() {
        return 16;
    }

    @Override
    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return 30.0f;
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return 5.0f;
    }

    @Override
    public boolean isSideSolid(int aMeta, byte aSide) {
        return (aMeta & 7) < 6 && aMeta == aSide;
    }

    @Override
    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean useGravity(byte aMeta) {
        return (aMeta & 7) == 7;
    }

    @Override
    public boolean doesWalkSpeed(byte aMeta) {
        return true;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean func_149646_a(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return true;
    }

    public void func_149666_a(Item aItem, CreativeTabs aTab, List aList) {
        aList.add(ST.make(aItem, 1L, 0L));
        aList.add(ST.make(aItem, 1L, 6L));
        aList.add(ST.make(aItem, 1L, 7L));
        aList.add(ST.make(aItem, 1L, 8L));
        aList.add(ST.make(aItem, 1L, 14L));
        aList.add(ST.make(aItem, 1L, 15L));
    }

    public ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        return ST.make(this, 1L, (aMeta & 7) < 6 ? (long)(aMeta & 8) : (long)aMeta);
    }

    public boolean rotateBlock(World aWorld, int aX, int aY, int aZ, ForgeDirection aAxis) {
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        return (aMeta & 7) < 6 && aWorld.func_147465_d(aX, aY, aZ, (Block)this, aMeta & 8 | ((aMeta & 7) + 1) % 6, 3);
    }

    public ForgeDirection[] getValidRotations(World aWorld, int aX, int aY, int aZ) {
        return (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) < 6 ? ForgeDirection.VALID_DIRECTIONS : null;
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, World aWorld, byte aSide, int aX, int aY, int aZ, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("wrench") || aTool.equals("rotator")) {
            if (aWorld.field_72995_K) {
                return 0L;
            }
            byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
            if ((aMeta & 7) >= 6) {
                return 0L;
            }
            byte tSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            return (aMeta & 7) != tSide && aWorld.func_147465_d(aX, aY, aZ, (Block)this, aMeta & 8 | tSide, 3) ? 2000L : 0L;
        }
        return ToolCompat.onToolClick(this, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
    }

    public AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        switch (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) {
            case 5: {
                return AxisAlignedBB.func_72330_a((double)((double)aX + 0.4), (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)((double)aY + 0.4), (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)((double)aZ + 0.4), (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)((double)aX + 0.6), (double)(aY + 1), (double)(aZ + 1));
            }
            case 0: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)((double)aY + 0.6), (double)(aZ + 1));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)((double)aZ + 0.6));
            }
        }
        return AxisAlignedBB.func_72330_a((double)((double)aX + 0.125), (double)((double)aY + 0.125), (double)((double)aZ + 0.125), (double)((double)aX + 0.875), (double)((double)aY + 0.875), (double)((double)aZ + 0.875));
    }

    public void func_149743_a(World aWorld, int aX, int aY, int aZ, AxisAlignedBB aAABB, List aList, Entity aEntity) {
        if (aEntity instanceof EntityItem || aEntity instanceof EntityXPOrb || aEntity instanceof IProjectile) {
            return;
        }
        super.func_149743_a(aWorld, aX, aY, aZ, aAABB, aList, aEntity);
    }

    public AxisAlignedBB func_149633_g(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1));
    }

    public int func_149645_b() {
        return RendererBlockTextured.INSTANCE == null ? 23 : RendererBlockTextured.INSTANCE.mRenderID;
    }

    public IIcon func_149691_a(int aSide, int aMeta) {
        return Blocks.field_150411_aY.func_149691_a(2, 0);
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, ItemStack aStack) {
        return null;
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return null;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public int getRenderPasses(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getRenderPasses(IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return 0;
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return this.mRenderers[ST.meta_(aStack) & 0xF];
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mRenderers[WD.meta(aWorld, aX, aY, aZ)];
    }

    public static class SpikeRendererOmni
    extends SpikeRendererBase {
        public SpikeRendererOmni(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
            return 13;
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[5], CS.PX_P[5], CS.PX_N[0], CS.PX_P[6], CS.PX_P[6]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[5], CS.PX_P[10], CS.PX_N[0], CS.PX_P[6], CS.PX_P[11]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[10], CS.PX_P[5], CS.PX_N[0], CS.PX_P[11], CS.PX_P[6]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[10], CS.PX_P[10], CS.PX_N[0], CS.PX_P[11], CS.PX_P[11]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[0], CS.PX_P[5], CS.PX_P[6], CS.PX_N[0], CS.PX_P[6]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[0], CS.PX_P[10], CS.PX_P[6], CS.PX_N[0], CS.PX_P[11]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[0], CS.PX_P[5], CS.PX_P[11], CS.PX_N[0], CS.PX_P[6]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[0], CS.PX_P[10], CS.PX_P[11], CS.PX_N[0], CS.PX_P[11]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[5], CS.PX_P[0], CS.PX_P[6], CS.PX_P[6], CS.PX_N[0]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[10], CS.PX_P[0], CS.PX_P[6], CS.PX_P[11], CS.PX_N[0]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[5], CS.PX_P[0], CS.PX_P[11], CS.PX_P[6], CS.PX_N[0]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[10], CS.PX_P[0], CS.PX_P[11], CS.PX_P[11], CS.PX_N[0]);
                    return true;
                }
            }
            aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[4], CS.PX_P[4], CS.PX_N[4], CS.PX_N[4], CS.PX_N[4]);
            return true;
        }
    }

    public static class SpikeRendererZNeg
    extends SpikeRendererBase {
        public SpikeRendererZNeg(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return 2 == aSide && (aRenderPass != 0 || !aShouldSideBeRendered[aSide]) ? null : super.getTexture(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            if (CS.APRIL_FOOLS) {
                switch (aRenderPass) {
                    case 1: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[2], CS.PX_P[1], CS.PX_P[7], CS.PX_P[7], CS.PX_N[5]);
                        return true;
                    }
                    case 2: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[9], CS.PX_P[1], CS.PX_P[7], CS.PX_P[14], CS.PX_N[5]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[2], CS.PX_P[1], CS.PX_P[14], CS.PX_P[7], CS.PX_N[5]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[1], CS.PX_P[14], CS.PX_P[14], CS.PX_N[5]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[8]);
                return true;
            }
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[4], CS.PX_P[1], CS.PX_P[5], CS.PX_P[5], CS.PX_N[1]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[11], CS.PX_P[1], CS.PX_P[5], CS.PX_P[12], CS.PX_N[1]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[4], CS.PX_P[1], CS.PX_P[12], CS.PX_P[5], CS.PX_N[1]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[11], CS.PX_P[1], CS.PX_P[12], CS.PX_P[12], CS.PX_N[1]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[3], CS.PX_P[1], CS.PX_P[6], CS.PX_P[6], CS.PX_N[5]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[10], CS.PX_P[1], CS.PX_P[6], CS.PX_P[13], CS.PX_N[5]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[3], CS.PX_P[1], CS.PX_P[13], CS.PX_P[6], CS.PX_N[5]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[10], CS.PX_P[1], CS.PX_P[13], CS.PX_P[13], CS.PX_N[5]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[2], CS.PX_P[1], CS.PX_P[7], CS.PX_P[7], CS.PX_N[9]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[9], CS.PX_P[1], CS.PX_P[7], CS.PX_P[14], CS.PX_N[9]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[2], CS.PX_P[1], CS.PX_P[14], CS.PX_P[7], CS.PX_N[9]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[1], CS.PX_P[14], CS.PX_P[14], CS.PX_N[9]);
                    return true;
                }
            }
            aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[14]);
            return true;
        }
    }

    public static class SpikeRendererZPos
    extends SpikeRendererBase {
        public SpikeRendererZPos(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return 3 == aSide && (aRenderPass != 0 || !aShouldSideBeRendered[aSide]) ? null : super.getTexture(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            if (CS.APRIL_FOOLS) {
                switch (aRenderPass) {
                    case 1: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[2], CS.PX_P[5], CS.PX_P[7], CS.PX_P[7], CS.PX_N[1]);
                        return true;
                    }
                    case 2: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[9], CS.PX_P[5], CS.PX_P[7], CS.PX_P[14], CS.PX_N[1]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[2], CS.PX_P[5], CS.PX_P[14], CS.PX_P[7], CS.PX_N[1]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[5], CS.PX_P[14], CS.PX_P[14], CS.PX_N[1]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[8], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[4], CS.PX_P[1], CS.PX_P[5], CS.PX_P[5], CS.PX_N[1]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[11], CS.PX_P[1], CS.PX_P[5], CS.PX_P[12], CS.PX_N[1]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[4], CS.PX_P[1], CS.PX_P[12], CS.PX_P[5], CS.PX_N[1]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[11], CS.PX_P[1], CS.PX_P[12], CS.PX_P[12], CS.PX_N[1]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[3], CS.PX_P[5], CS.PX_P[6], CS.PX_P[6], CS.PX_N[1]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[10], CS.PX_P[5], CS.PX_P[6], CS.PX_P[13], CS.PX_N[1]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[3], CS.PX_P[5], CS.PX_P[13], CS.PX_P[6], CS.PX_N[1]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[10], CS.PX_P[5], CS.PX_P[13], CS.PX_P[13], CS.PX_N[1]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[2], CS.PX_P[9], CS.PX_P[7], CS.PX_P[7], CS.PX_N[1]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[9], CS.PX_P[9], CS.PX_P[7], CS.PX_P[14], CS.PX_N[1]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[2], CS.PX_P[9], CS.PX_P[14], CS.PX_P[7], CS.PX_N[1]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[9], CS.PX_P[14], CS.PX_P[14], CS.PX_N[1]);
                    return true;
                }
            }
            aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[14], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            return true;
        }
    }

    public static class SpikeRendererYNeg
    extends SpikeRendererBase {
        public SpikeRendererYNeg(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return 0 == aSide && (aRenderPass != 0 || !aShouldSideBeRendered[aSide]) ? null : super.getTexture(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            if (CS.APRIL_FOOLS) {
                switch (aRenderPass) {
                    case 1: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[1], CS.PX_P[2], CS.PX_P[7], CS.PX_N[5], CS.PX_P[7]);
                        return true;
                    }
                    case 2: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[1], CS.PX_P[9], CS.PX_P[7], CS.PX_N[5], CS.PX_P[14]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[1], CS.PX_P[2], CS.PX_P[14], CS.PX_N[5], CS.PX_P[7]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[1], CS.PX_P[9], CS.PX_P[14], CS.PX_N[5], CS.PX_P[14]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[8], CS.PX_N[0]);
                return true;
            }
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[1], CS.PX_P[4], CS.PX_P[5], CS.PX_N[1], CS.PX_P[5]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[1], CS.PX_P[11], CS.PX_P[5], CS.PX_N[1], CS.PX_P[12]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[1], CS.PX_P[4], CS.PX_P[12], CS.PX_N[1], CS.PX_P[5]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[1], CS.PX_P[11], CS.PX_P[12], CS.PX_N[1], CS.PX_P[12]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[1], CS.PX_P[3], CS.PX_P[6], CS.PX_N[5], CS.PX_P[6]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[1], CS.PX_P[10], CS.PX_P[6], CS.PX_N[5], CS.PX_P[13]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[1], CS.PX_P[3], CS.PX_P[13], CS.PX_N[5], CS.PX_P[6]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[1], CS.PX_P[10], CS.PX_P[13], CS.PX_N[5], CS.PX_P[13]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[1], CS.PX_P[2], CS.PX_P[7], CS.PX_N[9], CS.PX_P[7]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[1], CS.PX_P[9], CS.PX_P[7], CS.PX_N[9], CS.PX_P[14]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[1], CS.PX_P[2], CS.PX_P[14], CS.PX_N[9], CS.PX_P[7]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[1], CS.PX_P[9], CS.PX_P[14], CS.PX_N[9], CS.PX_P[14]);
                    return true;
                }
            }
            aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[14], CS.PX_N[0]);
            return true;
        }
    }

    public static class SpikeRendererYPos
    extends SpikeRendererBase {
        public SpikeRendererYPos(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return 1 == aSide && (aRenderPass != 0 || !aShouldSideBeRendered[aSide]) ? null : super.getTexture(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            if (CS.APRIL_FOOLS) {
                switch (aRenderPass) {
                    case 1: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[5], CS.PX_P[2], CS.PX_P[7], CS.PX_N[1], CS.PX_P[7]);
                        return true;
                    }
                    case 2: {
                        aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[5], CS.PX_P[9], CS.PX_P[7], CS.PX_N[1], CS.PX_P[14]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[5], CS.PX_P[2], CS.PX_P[14], CS.PX_N[1], CS.PX_P[7]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[5], CS.PX_P[9], CS.PX_P[14], CS.PX_N[1], CS.PX_P[14]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[8], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[1], CS.PX_P[4], CS.PX_P[5], CS.PX_N[1], CS.PX_P[5]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[4], CS.PX_P[1], CS.PX_P[11], CS.PX_P[5], CS.PX_N[1], CS.PX_P[12]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[1], CS.PX_P[4], CS.PX_P[12], CS.PX_N[1], CS.PX_P[5]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[11], CS.PX_P[1], CS.PX_P[11], CS.PX_P[12], CS.PX_N[1], CS.PX_P[12]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[5], CS.PX_P[3], CS.PX_P[6], CS.PX_N[1], CS.PX_P[6]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[3], CS.PX_P[5], CS.PX_P[10], CS.PX_P[6], CS.PX_N[1], CS.PX_P[13]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[5], CS.PX_P[3], CS.PX_P[13], CS.PX_N[1], CS.PX_P[6]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[10], CS.PX_P[5], CS.PX_P[10], CS.PX_P[13], CS.PX_N[1], CS.PX_P[13]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[9], CS.PX_P[2], CS.PX_P[7], CS.PX_N[1], CS.PX_P[7]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[2], CS.PX_P[9], CS.PX_P[9], CS.PX_P[7], CS.PX_N[1], CS.PX_P[14]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[2], CS.PX_P[14], CS.PX_N[1], CS.PX_P[7]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[9], CS.PX_P[14], CS.PX_N[1], CS.PX_P[14]);
                    return true;
                }
            }
            aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[14], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            return true;
        }
    }

    public static class SpikeRendererXNeg
    extends SpikeRendererBase {
        public SpikeRendererXNeg(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return 4 == aSide && (aRenderPass != 0 || !aShouldSideBeRendered[aSide]) ? null : super.getTexture(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            if (CS.APRIL_FOOLS) {
                switch (aRenderPass) {
                    case 1: {
                        aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[2], CS.PX_P[2], CS.PX_N[5], CS.PX_P[7], CS.PX_P[7]);
                        return true;
                    }
                    case 2: {
                        aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[2], CS.PX_P[9], CS.PX_N[5], CS.PX_P[7], CS.PX_P[14]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[9], CS.PX_P[2], CS.PX_N[5], CS.PX_P[14], CS.PX_P[7]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[9], CS.PX_P[9], CS.PX_N[5], CS.PX_P[14], CS.PX_P[14]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[8], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[4], CS.PX_P[4], CS.PX_N[1], CS.PX_P[5], CS.PX_P[5]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[4], CS.PX_P[11], CS.PX_N[1], CS.PX_P[5], CS.PX_P[12]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[11], CS.PX_P[4], CS.PX_N[1], CS.PX_P[12], CS.PX_P[5]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[11], CS.PX_P[11], CS.PX_N[1], CS.PX_P[12], CS.PX_P[12]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[3], CS.PX_P[3], CS.PX_N[5], CS.PX_P[6], CS.PX_P[6]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[3], CS.PX_P[10], CS.PX_N[5], CS.PX_P[6], CS.PX_P[13]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[10], CS.PX_P[3], CS.PX_N[5], CS.PX_P[13], CS.PX_P[6]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[10], CS.PX_P[10], CS.PX_N[5], CS.PX_P[13], CS.PX_P[13]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[2], CS.PX_P[2], CS.PX_N[9], CS.PX_P[7], CS.PX_P[7]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[2], CS.PX_P[9], CS.PX_N[9], CS.PX_P[7], CS.PX_P[14]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[9], CS.PX_P[2], CS.PX_N[9], CS.PX_P[14], CS.PX_P[7]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[9], CS.PX_P[9], CS.PX_N[9], CS.PX_P[14], CS.PX_P[14]);
                    return true;
                }
            }
            aBlock.func_149676_a(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[14], CS.PX_N[0], CS.PX_N[0]);
            return true;
        }
    }

    public static class SpikeRendererXPos
    extends SpikeRendererBase {
        public SpikeRendererXPos(OreDictMaterial aMat) {
            super(aMat);
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return 5 == aSide && (aRenderPass != 0 || !aShouldSideBeRendered[aSide]) ? null : super.getTexture(aBlock, aRenderPass, aSide, aShouldSideBeRendered);
        }

        @Override
        public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
            if (CS.APRIL_FOOLS) {
                switch (aRenderPass) {
                    case 1: {
                        aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[2], CS.PX_P[2], CS.PX_N[1], CS.PX_P[7], CS.PX_P[7]);
                        return true;
                    }
                    case 2: {
                        aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[2], CS.PX_P[9], CS.PX_N[1], CS.PX_P[7], CS.PX_P[14]);
                        return true;
                    }
                    case 3: {
                        aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[9], CS.PX_P[2], CS.PX_N[1], CS.PX_P[14], CS.PX_P[7]);
                        return true;
                    }
                    case 4: {
                        aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[9], CS.PX_P[9], CS.PX_N[1], CS.PX_P[14], CS.PX_P[14]);
                        return true;
                    }
                }
                aBlock.func_149676_a(CS.PX_P[8], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
                return true;
            }
            switch (aRenderPass) {
                case 1: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[4], CS.PX_P[4], CS.PX_N[1], CS.PX_P[5], CS.PX_P[5]);
                    return true;
                }
                case 2: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[4], CS.PX_P[11], CS.PX_N[1], CS.PX_P[5], CS.PX_P[12]);
                    return true;
                }
                case 3: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[11], CS.PX_P[4], CS.PX_N[1], CS.PX_P[12], CS.PX_P[5]);
                    return true;
                }
                case 4: {
                    aBlock.func_149676_a(CS.PX_P[1], CS.PX_P[11], CS.PX_P[11], CS.PX_N[1], CS.PX_P[12], CS.PX_P[12]);
                    return true;
                }
                case 5: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[3], CS.PX_P[3], CS.PX_N[1], CS.PX_P[6], CS.PX_P[6]);
                    return true;
                }
                case 6: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[3], CS.PX_P[10], CS.PX_N[1], CS.PX_P[6], CS.PX_P[13]);
                    return true;
                }
                case 7: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[10], CS.PX_P[3], CS.PX_N[1], CS.PX_P[13], CS.PX_P[6]);
                    return true;
                }
                case 8: {
                    aBlock.func_149676_a(CS.PX_P[5], CS.PX_P[10], CS.PX_P[10], CS.PX_N[1], CS.PX_P[13], CS.PX_P[13]);
                    return true;
                }
                case 9: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[2], CS.PX_P[2], CS.PX_N[1], CS.PX_P[7], CS.PX_P[7]);
                    return true;
                }
                case 10: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[2], CS.PX_P[9], CS.PX_N[1], CS.PX_P[7], CS.PX_P[14]);
                    return true;
                }
                case 11: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[2], CS.PX_N[1], CS.PX_P[14], CS.PX_P[7]);
                    return true;
                }
                case 12: {
                    aBlock.func_149676_a(CS.PX_P[9], CS.PX_P[9], CS.PX_P[9], CS.PX_N[1], CS.PX_P[14], CS.PX_P[14]);
                    return true;
                }
            }
            aBlock.func_149676_a(CS.PX_P[14], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[0], CS.PX_N[0]);
            return true;
        }
    }

    public static abstract class SpikeRendererBase
    implements IRenderedBlockObject {
        public ITexture mTextureNormal;
        public ITexture mTextureUsed;

        public SpikeRendererBase(OreDictMaterial aMat) {
            this.mTextureUsed = this.mTextureNormal = aMat.getTextureSmooth();
        }

        @Override
        public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
            return CS.APRIL_FOOLS ? 5 : 13;
        }

        @Override
        public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
            return this.mTextureUsed;
        }

        @Override
        public boolean usesRenderPass(int aRenderPass, boolean[] aShouldSideBeRendered) {
            return true;
        }

        @Override
        public boolean renderItem(Block aBlock, RenderBlocks aRenderer) {
            return false;
        }

        @Override
        public boolean renderBlock(Block aBlock, RenderBlocks aRenderer, IBlockAccess aWorld, int aX, int aY, int aZ) {
            return false;
        }

        @Override
        public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
            this.mTextureUsed = this.mTextureNormal;
            return this;
        }

        @Override
        public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
            this.mTextureUsed = CS.APRIL_FOOLS ? BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.CFOAM_HARDENED, CS.RAINBOW_ARRAY[WD.random(42069L, aX, aY, aZ, 12) * 2]) : this.mTextureNormal;
            return this;
        }
    }
}

